/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.transhandlebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;

public class TransHandleBilCancelRefundService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(10);
        list.add("paidstatus");
        list.add("acrefundamt");
        list.add("acrefundreson");
        list.add("recbill");
        return list;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        Set transIds = Arrays.stream(dynamicObjects).map(o -> o.getPkValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", transIds);
        DynamicObject[] transBills = TmcDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id,paidstatus,acrefundamt,acrefundreson,recbill", (QFilter[])qFilter.toArray());
        HashMap<Long, Long> rectransMap = new HashMap<Long, Long>(transBills.length);
        for (DynamicObject tran : transBills) {
            if (tran.getDynamicObject("recbill") != null) {
                rectransMap.put(tran.getDynamicObject("recbill").getLong("id"), tran.getLong("id"));
            }
            tran.set("paidstatus", (Object)TransBillPaidStatusEnum.PAID.getValue());
            tran.set("acrefundamt", (Object)0);
            tran.set("acrefundreson", null);
            tran.set("recbill", null);
        }
        SaveServiceHelper.save((DynamicObject[])transBills);
        for (Map.Entry entry : rectransMap.entrySet()) {
            TmcBotpHelper.deleteRation((String)"ifm_transhandlebill", (Long)((Long)entry.getKey()), (Long)((Long)entry.getValue()));
        }
    }
}

