/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.transhandlebill;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.helper.DeductionPayHelper;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;

public class TransHandleBillCancelPayService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TransHandleBillCancelPayService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject transBill : dataEntities) {
            BankBillSyncStatusHelper.revertCasPayBill((DynamicObject)transBill);
            TransBillHelper.cancelJournal((DynamicObject)transBill);
            TransDetailService.asyncDeleteTransDetail((DynamicObject)transBill);
            this.revertUpstreamBills(transBill);
            transBill.set("paidstatus", (Object)TransBillPaidStatusEnum.WAITING.getValue());
            transBill.set("paydate", null);
            transBill.set("bankcheckflag", (Object)"");
            transBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            transBill.set("modifytime", (Object)new Date());
        }
        if (this.getOperationVariable().containsKey("cancelPayAndDelete")) {
            logger.info("OperationVariable contains cancelPayAndDelete");
            HashSet pkValueSet = new HashSet();
            Arrays.stream(dataEntities).forEach(o -> pkValueSet.add(o.getLong("id")));
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"ifm_transhandlebill", (Object[])pkValueSet.toArray(), (OperateOption)OperateOption.create());
        } else {
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
    }

    private void revertUpstreamBills(DynamicObject transBill) {
        TransBillHelper.revertPayAcceptanceBill((DynamicObject)transBill);
        DeductionPayHelper.revertDeductionBill((DynamicObject)transBill);
    }
}

