/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.transhandlebill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.ifm.bean.DeductionPayBean;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.enums.TransSourceTypeEnum;
import kd.tmc.ifm.helper.DeductionPayHelper;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;
import org.apache.commons.lang3.tuple.Pair;

public class TransHandleBillCommitIfmService
extends AbstractTmcBizOppService {
    private Map<Long, List<Long>> transDetailIdMap = new HashMap<Long, List<Long>>();
    private Map<Long, Pair<Long, String>> payBillIdBankCheckFlagMap = new HashMap<Long, Pair<Long, String>>(10);

    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("payeebanknum");
        list.add("payeracctbank");
        list.add("paidstatus");
        list.add("bankcheckflag");
        list.add("billstatus");
        list.add("org");
        list.add("agentpayeraccount");
        list.add("issetbankinterface");
        list.add("id");
        list.add("billno");
        list.add("createtime");
        list.add("creator");
        list.add("modifytime");
        list.add("modifier");
        list.add("auditdate");
        list.add("auditor");
        list.add("scorg");
        list.add("bizdate");
        list.add("currency");
        list.add("payerbank");
        list.add("description");
        list.add("actpayamt");
        list.add("payeebankname");
        list.add("payeeacctbank");
        list.add("payee");
        list.add("settletype");
        list.add("settletnumber");
        list.add("e_actamt");
        list.add("e_localamt");
        list.add("e_fundflowitem");
        list.add("payeename");
        list.add("payeebank");
        list.add("sourcebillid");
        list.add("recaccbankname");
        list.add("sourcebilltype");
        list.add("usage");
        list.add("transtype");
        list.add("iscommitbe");
        list.add("sourcebillentryid");
        list.add("paydate");
        list.add("bankreturnmsg");
        list.add("bankpaystatus");
        list.add("beibankcheckflag");
        return list;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DeductionPayBean> deductionPayBeans = new ArrayList<DeductionPayBean>(10);
        for (DynamicObject transBill : dataEntities) {
            this.updateBalAndCreateTransDetail(transBill);
            String sourceBillType = (String)transBill.get("sourcebilltype");
            if (TransSourceTypeEnum.IFM_PAYACCEPTANCEBILL.getValue().equals(sourceBillType)) {
                DynamicObject payacceptBill = TransBillHelper.syncAcceptanceBill((DynamicObject)transBill);
                Long payBillId = payacceptBill.getLong("sourcebillid");
                String bankCheckFlag = transBill.getString("bankcheckflag");
                this.payBillIdBankCheckFlagMap.put(transBill.getLong("id"), (Pair<Long, String>)Pair.of((Object)payBillId, (Object)bankCheckFlag));
                continue;
            }
            if (!TransSourceTypeEnum.IFM_DEDUCTION.getValue().equals(sourceBillType)) continue;
            Long deductionBillId = transBill.getLong("sourcebillid");
            Long sourceBillEntryId = transBill.getLong("sourcebillentryid");
            DeductionPayBean deductionPayBean = new DeductionPayBean();
            deductionPayBean.setBillId(deductionBillId);
            deductionPayBean.setEntryRowId(sourceBillEntryId);
            deductionPayBeans.add(deductionPayBean);
        }
        if (deductionPayBeans.size() > 0) {
            DeductionPayHelper.payConfirm(deductionPayBeans);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        ThreadPools.executeOnceIncludeRequestContext((String)"writebackCASPaybill_pay", () -> {
            for (Map.Entry<Long, Pair<Long, String>> checkMap : this.payBillIdBankCheckFlagMap.entrySet()) {
                SyncStatusInfo syncStatusInfo = BankBillSyncStatusHelper.getSyncStatusInfo((Long)checkMap.getKey(), (Long)((Long)checkMap.getValue().getKey()), (String)((String)checkMap.getValue().getRight()));
                BankBillSyncStatusHelper.syncPaymentBill((SyncStatusInfo)syncStatusInfo, null, this.transDetailIdMap.get(checkMap.getKey()), (boolean)true);
            }
        });
    }

    private void updateBalAndCreateTransDetail(DynamicObject transBill) {
        transBill.set("paidstatus", (Object)TransBillPaidStatusEnum.PAID.getValue());
        transBill.set("paydate", (Object)transBill.getDate("bizdate"));
        if (EmptyUtil.isEmpty((String)transBill.getString("bankcheckflag"))) {
            transBill.set("bankcheckflag", (Object)GenBankcheckCode.genCode());
        }
        DynamicObject[] transDetailArr = TransDetailService.createTransDetail((DynamicObject)transBill);
        String sourceBillType = transBill.getString("sourcebilltype");
        String transType = transBill.getString("transtype");
        if (TransDetailHelper.isNeedMatchCasBill((String)transType) || TransSourceTypeEnum.IFM_PAYACCEPTANCEBILL.getValue().equals(sourceBillType)) {
            this.transDetailIdMap.put(transBill.getLong("id"), TransDetailHelper.getTransDetails((DynamicObject[])transDetailArr, (boolean)true));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transBill});
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
    }
}

