/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.transhandlebill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.ifm.enums.SettleMentTypeEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;
import org.apache.commons.lang3.tuple.Pair;

public class TransHandleBillConfirmPayService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TransHandleBillConfirmPayService.class);
    private Map<Long, List<Long>> transDetailIdMap = new HashMap<Long, List<Long>>();
    private Map<Long, Pair<Long, String>> payBillIdBankCheckFlagMap = new HashMap<Long, Pair<Long, String>>(10);

    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("payeebanknum");
        list.add("payeracctbank");
        list.add("paidstatus");
        list.add("bankcheckflag");
        list.add("billstatus");
        list.add("org");
        list.add("agentpayeraccount");
        list.add("issetbankinterface");
        list.add("id");
        list.add("billno");
        list.add("createtime");
        list.add("creator");
        list.add("modifytime");
        list.add("modifier");
        list.add("auditdate");
        list.add("auditor");
        list.add("scorg");
        list.add("bizdate");
        list.add("currency");
        list.add("payerbank");
        list.add("description");
        list.add("actpayamt");
        list.add("payeebankname");
        list.add("payeeacctbank");
        list.add("payee");
        list.add("settletype");
        list.add("settletnumber");
        list.add("e_actamt");
        list.add("e_localamt");
        list.add("e_fundflowitem");
        list.add("payeename");
        list.add("payeebank");
        list.add("sourcebillid");
        list.add("recaccbankname");
        list.add("sourcebilltype");
        list.add("usage");
        list.add("transtype");
        list.add("iscommitbe");
        list.add("sourcebillentryid");
        list.add("paydate");
        list.add("bankreturnmsg");
        list.add("bankpaystatus");
        list.add("beibankcheckflag");
        list.add("bankaccount");
        list.add("iscrosspay");
        list.add("singlestream");
        return list;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject transBill : dynamicObjects) {
            boolean isBankBusSettle;
            Long id = (Long)transBill.getPkValue();
            transBill.set("paidstatus", (Object)TransBillPaidStatusEnum.PAID.getValue());
            transBill.set("paydate", (Object)transBill.getDate("bizdate"));
            DynamicObject settleType = transBill.getDynamicObject("settletype");
            boolean bl = isBankBusSettle = EmptyUtil.isNoEmpty((DynamicObject)settleType) && SettleMentTypeEnum.isBankOrBusiness((String)settleType.getString("settlementtype"));
            if (!isBankBusSettle && EmptyUtil.isEmpty((String)transBill.getString("bankcheckflag"))) {
                transBill.set("bankcheckflag", (Object)GenBankcheckCode.genCode());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transBill});
            this.book(transBill);
            TransBillHelper.writeDeDuctionPayAccStatus((DynamicObject)transBill);
            if (!"ifm_payacceptancebill".equals(transBill.getString("sourcebilltype"))) continue;
            String genCode = TransBillHelper.getBankCheckFlagToCas((DynamicObject)transBill, (String)transBill.getString("bankcheckflag"), (String)"");
            DynamicObject payacceptBill = TransBillHelper.syncAcceptanceBill((DynamicObject)transBill);
            Long payBillId = payacceptBill.getLong("sourcebillid");
            this.payBillIdBankCheckFlagMap.put(id, (Pair<Long, String>)Pair.of((Object)payBillId, (Object)genCode));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        ThreadPools.executeOnceIncludeRequestContext((String)"writebackCASPaybill_pay", () -> {
            for (Map.Entry<Long, Pair<Long, String>> checkMap : this.payBillIdBankCheckFlagMap.entrySet()) {
                SyncStatusInfo syncStatusInfo = BankBillSyncStatusHelper.getSyncStatusInfo((Long)checkMap.getKey(), (Long)((Long)checkMap.getValue().getKey()), (String)((String)checkMap.getValue().getRight()));
                BankBillSyncStatusHelper.syncPaymentBill((SyncStatusInfo)syncStatusInfo, null, this.transDetailIdMap.get(checkMap.getKey()), (boolean)true);
            }
        });
    }

    private void book(DynamicObject transBill) {
        DynamicObject[] transDetailArr = TransDetailService.createTransDetail((DynamicObject)transBill);
        String transType = transBill.getString("transtype");
        if (!TransTypeEnum.LINKAGE_PAY.getValue().equals(transType) && "ifm_payacceptancebill".equals(transBill.getString("sourcebilltype"))) {
            List detailIds = TransDetailHelper.getTransDetails((DynamicObject[])transDetailArr, (boolean)true);
            this.transDetailIdMap.put(transBill.getLong("id"), detailIds);
        }
        JournalBookHelper.doBookJournal((DynamicObject)transBill);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> cancleSuccessPks = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dt : dataEntities) {
            cancleSuccessPks.add((Long)dt.getPkValue());
        }
        JournalBookHelper.cancelJournal((String)dataEntities[0].getDataEntityType().getName(), cancleSuccessPks);
    }
}

