/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.opservice.transhandlebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.MatchStatusEnum;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.helper.VoucherHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusInfo;
import kd.tmc.ifm.bean.JournalInfo;
import kd.tmc.ifm.business.opservice.helper.TransBillBusHelper;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.enums.TransSourceTypeEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.helper.TransBillHelper;
import kd.tmc.ifm.helper.TransDetailHelper;
import kd.tmc.ifm.mservice.ebservice.sync.BankBillSyncStatusHelper;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;
import org.apache.commons.lang3.tuple.Pair;

public class TransHandleBillSaveService
extends AbstractTmcBizOppService {
    private Map<Long, List<Long>> transDetailIdMap = new HashMap<Long, List<Long>>();
    private Map<Long, Pair<Long, String>> payBillIdBankCheckFlagMap = new HashMap<Long, Pair<Long, String>>(10);
    private List<Long> transPayDetails = new ArrayList<Long>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("settletype");
        selector.add("feepayer");
        selector.add("feeactbank");
        selector.add("feecurrency");
        selector.add("singlestream");
        selector.add("iscrosspay");
        selector.add("fee");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, Long> billIdToSorgMap = new HashMap<Long, Long>(dataEntities.length);
        ArrayList<JournalInfo> journals = new ArrayList<JournalInfo>();
        for (DynamicObject transBill : dataEntities) {
            DynamicObject scorg;
            String matchFlag = transBill.getString("matchflag");
            if (MatchStatusEnum.UNSMARTMATCH.getValue().equals(matchFlag)) {
                transBill.set("matchamountpay", (Object)BigDecimal.ZERO);
            }
            transBill.set("unmatchamountpay", (Object)transBill.getBigDecimal("actpayamt").subtract(transBill.getBigDecimal("matchamountpay")));
            TransBillBusHelper.setTransFee(transBill);
            if (!this.autoSetPaidStatus(transBill)) continue;
            this.createTransDetail(transBill);
            String sourceBillType = (String)transBill.get("sourcebilltype");
            if (TransSourceTypeEnum.isIfmPayacceptancebill((String)sourceBillType)) {
                Long payacceptBillId = (Long)transBill.get("sourcebillid");
                DynamicObject payacceptBill = QueryServiceHelper.queryOne((String)"ifm_payacceptancebill", (String)"sourcebillid", (QFilter[])new QFilter("id", "=", (Object)payacceptBillId).toArray());
                Long payBillId = payacceptBill.getLong("sourcebillid");
                String bankCheckFlag = transBill.getString("bankcheckflag");
                this.payBillIdBankCheckFlagMap.put(transBill.getLong("id"), (Pair<Long, String>)Pair.of((Object)payBillId, (Object)bankCheckFlag));
            }
            if (TransTypeEnum.isInnerFundTransfer((Object)transBill.getString("transtype")) || TransBillHelper.isTranPassivePay((DynamicObject)transBill)) {
                journals.add(JournalBookHelper.createJournalInfo((DynamicObject)transBill));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(scorg = transBill.getDynamicObject("scorg")))) continue;
            billIdToSorgMap.put(transBill.getLong("id"), scorg.getLong("id"));
        }
        if (journals.size() > 0) {
            JournalBookHelper.ifmBookJournal(journals);
        }
        VoucherHelper.voucherWhiteListOpe((String)"ifm_transhandlebill", (String)"audit", new ArrayList(billIdToSorgMap.keySet()), billIdToSorgMap, (boolean)true);
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        ThreadPools.executeOnceIncludeRequestContext((String)"writebackCASPaybill_save", () -> {
            for (Map.Entry<Long, Pair<Long, String>> checkMap : this.payBillIdBankCheckFlagMap.entrySet()) {
                SyncStatusInfo syncStatusInfo = BankBillSyncStatusHelper.getSyncStatusInfo((Long)checkMap.getKey(), (Long)((Long)checkMap.getValue().getKey()), (String)((String)checkMap.getValue().getRight()));
                BankBillSyncStatusHelper.syncPaymentBill((SyncStatusInfo)syncStatusInfo, null, this.transDetailIdMap.get(checkMap.getKey()), (boolean)true);
            }
            if (this.transPayDetails.size() > 0) {
                TransDetailHelper.matchBillByBankCheckFlag(this.transPayDetails, (boolean)true);
            }
        });
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> cancleSuccessPks = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dt : dataEntities) {
            String transType = dt.getString("transtype");
            if (!transType.equals(TransTypeEnum.INNER_FUND_TRANSFER.getValue()) && !TransBillHelper.isTranPassivePay((DynamicObject)dt)) continue;
            cancleSuccessPks.add((Long)dt.getPkValue());
        }
        JournalBookHelper.cancelJournal((String)dataEntities[0].getDataEntityType().getName(), cancleSuccessPks);
    }

    private void createTransDetail(DynamicObject transBill) {
        transBill.set("paidstatus", (Object)TransBillPaidStatusEnum.PAID.getValue());
        if (EmptyUtil.isEmpty((Object)transBill.getDate("paydate"))) {
            transBill.set("paydate", (Object)DateUtils.getCurrentDate());
        }
        transBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        if (EmptyUtil.isEmpty((Object)transBill.get("bankcheckflag"))) {
            transBill.set("bankcheckflag", (Object)GenBankcheckCode.genCode());
        }
        DynamicObject[] transDetails = TransDetailService.createTransDetail((DynamicObject)transBill);
        String sourceBillType = transBill.getString("sourcebilltype");
        if (TransSourceTypeEnum.isIfmPayacceptancebill((String)sourceBillType)) {
            List transDetailIds = TransDetailHelper.getTransDetails((DynamicObject[])transDetails, (boolean)true);
            this.transDetailIdMap.put(transBill.getLong("id"), transDetailIds);
        } else if (!TransSourceTypeEnum.isIfmDeduction((String)sourceBillType)) {
            boolean isPay = !TransTypeEnum.isRelease((Object)transBill.getString("transtype"));
            List transDetailIds = TransDetailHelper.getTransDetails((DynamicObject[])transDetails, (boolean)isPay);
            this.transPayDetails.addAll(transDetailIds);
        }
    }

    private boolean autoSetPaidStatus(DynamicObject transBill) {
        if (TransBillPaidStatusEnum.isPaid((String)transBill.getString("paidstatus"))) {
            return false;
        }
        return TransTypeEnum.isAutoPayType((String)transBill.getString("transtype")) || TransBillHelper.isTranPassivePay((DynamicObject)transBill);
    }
}

