/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.accountacceptance;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BusinessTypeEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.InnerAcctHelper;

public class AccountAcceptanceUnauditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("businessstatus");
        list.add("businesstype");
        list.add("accountbank");
        return list;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject billDO = dataEntity.getDataEntity();
            String businessType = billDO.getString("businesstype");
            if (BusinessTypeEnum.OPEN.getValue().equals(businessType)) {
                this.validateOpenApply(dataEntity);
                continue;
            }
            if (!BusinessTypeEnum.CHANGE.getValue().equals(businessType)) continue;
            this.validateChangeApply(dataEntity);
        }
    }

    private void validateOpenApply(ExtendedDataEntity dataEntity) {
        DynamicObject billDO = dataEntity.getDataEntity();
        DynamicObject pushedInnerAcct = TmcBotpHelper.getTargetBill((String)"ifm_accountacceptancebill", (Object)billDO.getPkValue(), (String)"ifm_inneracct");
        if (pushedInnerAcct == null) {
            return;
        }
        List refEntityNames = InnerAcctHelper.getRefEntityNames((String)"ifm_inneracct", (Object)pushedInnerAcct.getPkValue(), (List)InnerAcctHelper.INNERACCT_IGNORE_REF_ON_DELETE);
        if (!refEntityNames.isEmpty()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5f15\u7528\u8be5\u8d26\u6237", (String)"AccountAcceptanceUnauditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]), String.join((CharSequence)",", refEntityNames)));
        } else {
            DynamicObject bankAcct = TmcAccountHelper.getBankAcctByInnerAcct((DynamicObject)pushedInnerAcct);
            if (bankAcct != null) {
                List acctBankRefs = InnerAcctHelper.getRefEntityNames((String)"bd_accountbanks", (Object)bankAcct.getPkValue(), (List)InnerAcctHelper.BANKACCT_IGNORE_REF_ON_DELETE);
                refEntityNames.addAll(acctBankRefs);
            }
            if (!refEntityNames.isEmpty()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5f15\u7528\u8be5\u8d26\u6237", (String)"AccountAcceptanceUnauditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]), String.join((CharSequence)",", refEntityNames)));
            }
        }
        QFilter qf = new QFilter("inneraccount.id", "=", pushedInnerAcct.getPkValue());
        qf.and(new QFilter("isinit", "=", (Object)true));
        if (TmcDataServiceHelper.exists((String)"ifm_inneraccountinit", (QFilter[])qf.toArray())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u521d\u59cb\u5316", (String)"AccountAcceptanceUnauditValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateChangeApply(ExtendedDataEntity dataEntity) {
        boolean allowUnaudit = false;
        DynamicObject bizDeal = dataEntity.getDataEntity();
        Optional<Object> innerAcctOption = Optional.ofNullable(bizDeal.getDynamicObject("accountbank")).map(r -> r.getDynamicObject("inneracct")).map(r -> r.getPkValue());
        if (!innerAcctOption.isPresent()) {
            return;
        }
        DynamicObjectCollection latestVersion = QueryServiceHelper.query((String)"fcs_changehistory", (String)"applyid", (QFilter[])new QFilter[]{new QFilter("bizid", "=", innerAcctOption.get())}, (String)"createtime desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)latestVersion) && bizDeal.getLong("id") == ((DynamicObject)latestVersion.get(0)).getLong("applyid")) {
            allowUnaudit = true;
        }
        if (!allowUnaudit) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6700\u540e\u4e00\u7b14\u53d8\u66f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"AccountAcceptanceUnauditValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

