/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.accountfrozen;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.ifm.business.validator.accountfrozen.InnerAccountFrozenSaveValidator;
import kd.tmc.ifm.enums.InnerAccountFrozenTypeEnum;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;

public class InnerAccountFrozenUnAuditValidator
extends AbstractTmcBizOppValidator {
    private final InnerAccountFrozenSaveValidator frozenSaveValidator = new InnerAccountFrozenSaveValidator();
    private static final String TMC_IFM_BUSINESS = "tmc-ifm-business";
    private static final String SELECT_PROPERTIES = "id,acctstatus";

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("frozenenddate");
        selector.add("account");
        selector.add("account.number");
        selector.add("account.acctstatus");
        selector.add("settlecenter");
        selector.add("applydate");
        selector.add("auditdate");
        selector.add("frozentype");
        selector.add("frozenamount");
        selector.add("totalfrozenamount");
        selector.add("frozenstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkInnerAcctStatusForUnAudit(dataEntity);
        }
    }

    private void checkInnerAcctStatusForUnAudit(ExtendedDataEntity extendedDataEntity) {
        DynamicObject accountFrozen = extendedDataEntity.getDataEntity();
        String frozenType = accountFrozen.getString("frozentype");
        DynamicObject innerAccount = accountFrozen.getDynamicObject("account");
        String acctStatus = innerAccount.getString("acctstatus");
        if (InnerAccountFrozenTypeEnum.isAccountFrozen((String)frozenType) && InnerAcctStatusEnum.isNormal((String)acctStatus)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d26\u6237\u72b6\u6001\u4e3a\u6b63\u5e38\u7684\u201c\u5185\u90e8\u8d26\u6237\u201d\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"InnerAccountFrozenUnAuditValidator_0", (String)TMC_IFM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (InnerAccountFrozenTypeEnum.isAccountThaw((String)frozenType) && InnerAcctStatusEnum.isFrozen((String)acctStatus)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d26\u6237\u72b6\u6001\u4e3a\u51bb\u7ed3\u7684\u201c\u5185\u90e8\u8d26\u6237\u201d\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"InnerAccountFrozenUnAuditValidator_1", (String)TMC_IFM_BUSINESS, (Object[])new Object[0]));
        }
    }
}

