/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.bankint.writeoff;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankPreIntUnWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("biztype");
        selector.add("intobject");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.validateBizType(extendedDataEntity);
            this.validateWriteOffOrder(extendedDataEntity);
        }
    }

    private void validateBizType(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankPreInt = extendedDataEntity.getDataEntity();
        String bizType = bankPreInt.getString("biztype");
        if (!StringUtils.equals((CharSequence)bizType, (CharSequence)"reverseint")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u64cd\u4f5c\u7c7b\u522b\u4e3a\u51b2\u9500\u9884\u63d0\u5229\u606f\u7684\u5355\u636e\u8fdb\u884c\u53cd\u51b2\u9500\u3002", (String)"BankPreIntUnWriteOffValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateWriteOffOrder(ExtendedDataEntity extendedDataEntity) {
        DynamicObject bankPreInt = extendedDataEntity.getDataEntity();
        QFilter qfilter = new QFilter("biztype", "=", (Object)"reverseint");
        qfilter.and(new QFilter("intobject", "=", bankPreInt.getDynamicObject("intobject").getPkValue()));
        Object[] bankPreInts = TmcDataServiceHelper.load((String)bankPreInt.getDataEntityType().getName(), (String)"id", (QFilter[])qfilter.toArray(), (String)"interestday desc, createtime desc");
        if (EmptyUtil.isNoEmpty((Object[])bankPreInts) && !bankPreInts[0].getPkValue().equals(bankPreInt.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540e\u7eed\u64cd\u4f5c\u7c7b\u522b\u4e3a\u51b2\u9500\u9884\u63d0\u5229\u606f\u7684\u9884\u63d0\u5355\u4e0d\u80fd\u53cd\u51b2\u9500\u3002", (String)"BankPreIntUnWriteOffValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

