/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.bizdeal;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerLoanAppliTypeEnum;
import kd.tmc.ifm.resource.IfmBizResource;

public class BizDealCenterSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("amount");
        selector.add("businessstatus");
        selector.add("applitype");
        selector.add("finproduct");
        selector.add("amount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        for (ExtendedDataEntity ede : dataEntity) {
            BigDecimal amount;
            DynamicObject dyn = ede.getDataEntity();
            String businessstatus = dyn.getString("businessstatus");
            if ("D".equals(businessstatus)) {
                this.addErrorMessage(ede, ifmBizResource.checkBizStatusForSubmit());
            }
            DynamicObject finproduct = dyn.getDynamicObject("finproduct");
            String appliType = dyn.getString("applitype");
            if (finproduct == null && !InnerLoanAppliTypeEnum.extend_apply.getValue().equals(appliType)) {
                this.addErrorMessage(ede, ifmBizResource.checkFinProductForSubmit());
            }
            if (!InnerLoanAppliTypeEnum.fin_apply.getValue().equals(appliType) || !EmptyUtil.isEmpty((BigDecimal)(amount = dyn.getBigDecimal("amount")))) continue;
            this.addErrorMessage(ede, ifmBizResource.getAmountTip());
        }
    }
}

