/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.bizdeal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.InnerLoanAppliTypeEnum;
import kd.tmc.ifm.resource.IfmBizResource;

public class BizDealCenterUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applitype");
        selector.add("sourcebillno");
        selector.add("iscallint");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        for (ExtendedDataEntity ede : dataEntity) {
            DynamicObject billDyn = ede.getDataEntity();
            String appliType = billDyn.getString("applitype");
            Map downStreamBillMap = BFTrackerServiceHelper.findTargetBills((String)this.getEntityNameFromAppliType(appliType, billDyn), (Long[])new Long[]{this.getPushSrcBillId(appliType, billDyn)});
            if (downStreamBillMap.size() == 0 || !InnerLoanAppliTypeEnum.fin_apply.getValue().equals(appliType) || !this.validateBillsStatus(downStreamBillMap)) continue;
            this.addErrorMessage(ede, ifmBizResource.checkDownStreamBillStatus());
        }
    }

    private String getEntityNameFromAppliType(String appliType, DynamicObject bizDeal) {
        String entityName = "";
        switch (appliType) {
            case "fin_apply": {
                entityName = bizDeal.getDataEntityType().getName();
                break;
            }
            case "loan_apply": {
                entityName = "cfm_loanbill";
                break;
            }
            case "repay_apply": {
                entityName = "cfm_repaymentbill";
                break;
            }
            case "int_apply": {
                entityName = "cfm_interestbill";
                break;
            }
            case "extend_apply": {
                entityName = "cfm_contractextendbill";
                break;
            }
        }
        return entityName;
    }

    private Long getPushSrcBillId(String appliType, DynamicObject bizDeal) {
        Long srcId = 0L;
        srcId = InnerLoanAppliTypeEnum.fin_apply.getValue().equals(appliType) ? Long.valueOf(bizDeal.getLong("id")) : Long.valueOf(bizDeal.getLong("sourcebillid"));
        return srcId;
    }

    private boolean validateBillsStatus(Map<String, HashSet<Long>> map) {
        boolean resFlag = false;
        String entityName = "";
        HashSet idSet = new HashSet(2);
        for (Map.Entry<String, HashSet<Long>> entry : map.entrySet()) {
            entityName = entry.getKey();
            idSet.addAll(entry.getValue());
        }
        QFilter qFilter = new QFilter("id", "in", idSet);
        DynamicObjectCollection trackDownBillCol = QueryServiceHelper.query((String)entityName, (String)"billstatus", (QFilter[])qFilter.toArray());
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)trackDownBillCol)) {
            for (int i = 0; i < trackDownBillCol.size(); ++i) {
                DynamicObject trackDownBill = (DynamicObject)trackDownBillCol.get(i);
                if ("A".equals(trackDownBill.getString("billstatus"))) continue;
                resFlag = true;
                break;
            }
        }
        return resFlag;
    }
}

