/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.bizdeal;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillTypeEnum;
import kd.tmc.ifm.enums.InnerLoanAppliTypeEnum;

public class BizDealLoanChgUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applitype");
        selector.add("sourcebillno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity ede : dataEntity) {
            DynamicObject bizDeal = ede.getDataEntity();
            if (!InnerLoanAppliTypeEnum.isLoanChangeApply((String)bizDeal.getString("applitype"))) continue;
            Long srcId = bizDeal.getLong("sourcebillid");
            QFilter qFilter = new QFilter("id", "=", (Object)srcId);
            DynamicObject applyBill = QueryServiceHelper.queryOne((String)"cfm_apply_loanbill", (String)"id, loanbill, loanbillno, modifytime", (QFilter[])qFilter.toArray());
            this.checkAfterChgBill(ede, applyBill);
        }
    }

    private void checkAfterChgBill(ExtendedDataEntity dataEntity, DynamicObject applyBill) {
        DynamicObject afterChgAdjust;
        DynamicObject afterChgExtend;
        DynamicObject afterChgPreInt;
        DynamicObject afterChgPreIntBatch;
        DynamicObject afterChgPayInt;
        DynamicObject afterChgPayIntBatch;
        Date modifyTime = applyBill.getDate("modifytime");
        Long loanBillId = applyBill.getLong("loanbill");
        String loanBillNo = applyBill.getString("loanbillno");
        DynamicObject repaymentBill = BizDealLoanChgUnAuditValidator.getAfterChgRepaymentBill(loanBillId, modifyTime);
        if (EmptyUtil.isNoEmpty((DynamicObject)repaymentBill)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e\u5355%1$s\u5b58\u5728\u53d8\u66f4\u540e\u65b0\u589e\u7684\u8fd8\u6b3e/\u672c\u91d1\u6536\u56de\u5355%2$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LoanBillApplyUnAuditValidator_3", (String)"tmc-ifm-business", (Object[])new Object[]{loanBillNo, repaymentBill.getString("billno")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgPayIntBatch = BizDealLoanChgUnAuditValidator.queryAfterChgPayIntBatch(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e\u5355%1$s\u5b58\u5728\u53d8\u66f4\u540e\u65b0\u589e\u7684\u6279\u91cf\u4ed8\u606f/\u6536\u606f\u5355%2$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LoanBillApplyUnAuditValidator_4", (String)"tmc-ifm-business", (Object[])new Object[]{loanBillNo, afterChgPayIntBatch.getString("billno")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgPayInt = BizDealLoanChgUnAuditValidator.queryAfterChgPayInt(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e\u5355%1$s\u5b58\u5728\u53d8\u66f4\u540e\u65b0\u589e\u7684\u4ed8\u606f/\u6536\u606f\u5355%2$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LoanBillApplyUnAuditValidator_5", (String)"tmc-ifm-business", (Object[])new Object[]{loanBillNo, afterChgPayInt.getString("billno")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgPreIntBatch = BizDealLoanChgUnAuditValidator.queryAfterChgPreIntBatch(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e\u5355%1$s\u5b58\u5728\u53d8\u66f4\u540e\u65b0\u589e\u7684\u6279\u91cf\u4ed8\u606f/\u6536\u606f\u9884\u63d0\u5355%2$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LoanBillApplyUnAuditValidator_6", (String)"tmc-ifm-business", (Object[])new Object[]{loanBillNo, afterChgPreIntBatch.getString("billno")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgPreInt = BizDealLoanChgUnAuditValidator.queryAfterChgPreInt(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e\u5355%1$s\u5b58\u5728\u53d8\u66f4\u540e\u65b0\u589e\u7684\u4ed8\u606f/\u6536\u606f\u9884\u63d0\u5355%2$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LoanBillApplyUnAuditValidator_7", (String)"tmc-ifm-business", (Object[])new Object[]{loanBillNo, afterChgPreInt.getString("billno")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgExtend = BizDealLoanChgUnAuditValidator.queryAfterChgExtend(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e\u5355%1$s\u5b58\u5728\u53d8\u66f4\u540e\u65b0\u589e\u7684\u5c55\u671f\u5355%2$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LoanBillApplyUnAuditValidator_8", (String)"tmc-ifm-business", (Object[])new Object[]{loanBillNo, afterChgExtend.getString("billno")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(afterChgAdjust = BizDealLoanChgUnAuditValidator.queryAfterChgAdjust(loanBillId, modifyTime)))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u6b3e\u5355%1$s\u5b58\u5728\u53d8\u66f4\u540e\u65b0\u589e\u7684\u5229\u7387\u8c03\u6574\u5355%2$s\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"LoanBillApplyUnAuditValidator_9", (String)"tmc-ifm-business", (Object[])new Object[]{loanBillNo, afterChgAdjust.getString("billno")}));
        }
    }

    public static DynamicObject getAfterChgRepaymentBill(Long loanBillId, Date modifyTime) {
        QFilter qFilter = new QFilter("loans.e_loanbill", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime);
        return QueryServiceHelper.queryOne((String)"cfm_repaymentbill", (String)"billno", (QFilter[])qFilter.toArray());
    }

    public static DynamicObject queryAfterChgPayIntBatch(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgPayIntBatch = QueryServiceHelper.queryOne((String)"cfm_intbill_batch_loan", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.loanbillid", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime).and("biztype", "=", (Object)BillTypeEnum.LOAN.getValue())});
        return afterChgPayIntBatch;
    }

    public static DynamicObject queryAfterChgPayInt(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgPayInt = QueryServiceHelper.queryOne((String)"cfm_interestbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime)});
        return afterChgPayInt;
    }

    public static DynamicObject queryAfterChgPreIntBatch(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgPreIntBatch = QueryServiceHelper.queryOne((String)"cfm_intbill_batch_pre", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.loanbillid", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime).and(new QFilter("biztype", "=", (Object)BillTypeEnum.PREINT.getValue()))});
        return afterChgPreIntBatch;
    }

    public static DynamicObject queryAfterChgPreInt(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgPreInt = QueryServiceHelper.queryOne((String)"cfm_preinterestbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)loanBillId).and("createtime", ">=", (Object)modifyTime)});
        return afterChgPreInt;
    }

    public static DynamicObject queryAfterChgAdjust(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgAdjust = QueryServiceHelper.queryOne((String)"cfm_rateadjustbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("entry.ldrawbill", "=", (Object)loanBillId).and("entry.lisadjust", "=", (Object)true).and("createtime", ">=", (Object)modifyTime)});
        return afterChgAdjust;
    }

    public static DynamicObject queryAfterChgExtend(Long loanBillId, Date modifyTime) {
        DynamicObject afterChgExtend = QueryServiceHelper.queryOne((String)"cfm_contractextendbill", (String)"id, billno", (QFilter[])new QFilter[]{new QFilter("loanbilllist.drawbillid", "=", (Object)loanBillId).and("loanbilllist.isrenewal", "=", (Object)true).and("createtime", ">=", (Object)modifyTime)});
        return afterChgExtend;
    }
}

