/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deduction;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.ifm.enums.PayStatusEnum;

public class DeductionAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(20);
        selector.add("entryentity");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("paystatus");
        selector.add("sourceentryid");
        selector.add("receiveamount");
        selector.add("payamount");
        selector.add("returncomment");
        selector.add("realamount");
        selector.add("receivecurrency");
        selector.add("bizdate");
        selector.add("comment");
        selector.add("billno");
        selector.add("beibankcheckflag");
        selector.add("scorg");
        selector.add("paybankaccount");
        selector.add("payeename");
        selector.add("payeebanknum");
        selector.add("payeebank");
        selector.add("createtime");
        selector.add("creator");
        selector.add("deductiontype");
        selector.add("payeetype");
        selector.add("paybank");
        selector.add("payee");
        selector.add("payeeaccountbank");
        selector.add("receivecompany");
        selector.add("receiveaccount");
        selector.add("payeebankname");
        selector.add("center");
        selector.add("paymentidentify");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObjectCollection entrys;
            long count;
            DynamicObject data = dataEntity.getDataEntity();
            BigDecimal realAmt = data.getBigDecimal("realamount");
            BigDecimal amout = data.getBigDecimal("receiveamount");
            DynamicObject currency = data.getDynamicObject("receivecurrency");
            if (realAmt.compareTo(amout) >= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u9645\u6263\u6b3e\u91d1\u989d\u4e3a[%s]\uff0c\u672a\u6263\u6b3e\u91d1\u989d\u4e3a0", (String)"DeductionAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[]{realAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP)}));
            }
            if ((count = (entrys = data.getDynamicObjectCollection("entryentity")).stream().filter(o -> PayStatusEnum.WAIT.getValue().equals(o.getString("paystatus")) || PayStatusEnum.FAILED.getValue().equals(o.getString("paystatus"))).count()) != 0L) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6263\u6b3e\u660e\u7ec6\u4e2d\u4e0d\u5b58\u5728\u5f85\u4ed8\u6b3e\u6216\u4ed8\u6b3e\u5931\u8d25\u72b6\u6001\u7684\u5206\u5f55", (String)"DeductionAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

