/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deduction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;

public class DeductionPushValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(8);
        selector.add("deductiontype");
        selector.add("bizstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            QFilter filter;
            boolean isPush;
            DynamicObject data = dataEntity.getDataEntity();
            String type = data.getString("deductiontype");
            String entityName = DeductionTypeEnum.CENTER_REFUND.getValue().equals(type) ? "ifm_rectransbill" : "ifm_transhandlebill";
            Object[] targetBillIds = TmcBotpHelper.getTargetBillIds((String)data.getDataEntityType().getName(), (Object)data.getLong("id"), (String)"ifm_transhandlebill");
            if (!EmptyUtil.isNoEmpty((Object[])targetBillIds) || !(isPush = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{filter = new QFilter("id", "in", (Object)targetBillIds).and("paidstatus", "not in", Arrays.asList(TransBillPaidStatusEnum.REFUSED.getValue(), TransBillPaidStatusEnum.RETURNTICKET.getValue()))}))) continue;
            String msg = ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5df2\u751f\u6210\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210\u3002", (String)"DeductionPushValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]);
            if ("ifm_transhandlebill".equals(entityName)) {
                msg = ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5df2\u751f\u6210\u6536\u6b3e\u8bb0\u8d26\u4e2d\u5fc3\uff0c\u8bf7\u52ff\u91cd\u590d\u751f\u6210\u3002", (String)"DeductionPushValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]);
            }
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

