/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deduction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.validator.transhandlebill.AbstractTransBillCancelPayValidator;
import kd.tmc.ifm.enums.DeductionTypeEnum;
import kd.tmc.ifm.enums.PayStatusEnum;
import kd.tmc.ifm.enums.RecTransPayStatusEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.helper.TransBillHelper;

public class DeductionUnAuditValidator
extends AbstractTransBillCancelPayValidator {
    @Override
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("paystatus");
        selector.add("deductiontype");
        selector.add("paymentidentify");
        selector.add("realamount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ArrayList<Long> checkJournalBillIds = new ArrayList<Long>(extendedDataEntities.length);
        Map<Long, ExtendedDataEntity> idEntityMap = this.toIdEntityMap(extendedDataEntities);
        ArrayList<Long> checkTransBills = new ArrayList<Long>(extendedDataEntities.length);
        ArrayList<Long> checkRecTransBills = new ArrayList<Long>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject deduction = extendedDataEntity.getDataEntity();
            String deductionType = deduction.getString("deductiontype");
            boolean isPassivePay = TransBillHelper.isPassivePay((DynamicObject)deduction.getDynamicObject("paymentidentify"), (String)deduction.getString("deductiontype"));
            if (DeductionTypeEnum.CENTER_AGENT.getValue().equals(deductionType) && !isPassivePay) {
                DynamicObjectCollection entry = deduction.getDynamicObjectCollection("entryentity");
                List notFailedPayStatusList = entry.stream().map(row -> row.get("paystatus")).filter(status -> !PayStatusEnum.FAILED.getValue().equals(status)).collect(Collectors.toList());
                if (EmptyUtil.isNoEmpty(notFailedPayStatusList)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u8bf7\u4ece\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u505a\u9000\u5355\u5904\u7406", (String)"DeductionUnAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (deduction.getBigDecimal("realamount").compareTo(BigDecimal.ZERO) > 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b9e\u9645\u6263\u6b3e\u91d1\u989d\u4e3a0\u65f6\u624d\u53ef\u4ee5\u53cd\u5ba1\u6838", (String)"DeductionUnAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                checkTransBills.add(deduction.getLong("id"));
            } else if (DeductionTypeEnum.CENTER_REFUND.getValue().equals(deductionType)) {
                checkRecTransBills.add(deduction.getLong("id"));
            } else {
                checkTransBills.add(deduction.getLong("id"));
            }
            if (!isPassivePay) continue;
            checkJournalBillIds.add(deduction.getLong("id"));
        }
        if (checkTransBills.size() > 0) {
            this.checkTranBills(checkTransBills, idEntityMap);
        }
        if (checkRecTransBills.size() > 0) {
            this.checkRecTranBills(checkRecTransBills, idEntityMap);
        }
        if (!checkJournalBillIds.isEmpty()) {
            this.checkJournal(idEntityMap, "ifm_deduction", checkJournalBillIds);
        }
    }

    private void checkTranBills(List<Long> checkTransBills, Map<Long, ExtendedDataEntity> extendeMap) {
        DynamicObjectCollection transBills = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", checkTransBills), new QFilter("sourcebilltype", "=", (Object)"ifm_deduction"), new QFilter("paidstatus", "=", (Object)TransBillPaidStatusEnum.PAID.getValue())});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)transBills)) {
            return;
        }
        Map<Long, Long> detailToTransMap = transBills.stream().collect(Collectors.toMap(o -> o.getLong("id"), v -> v.getLong("sourcebillid"), (k1, k2) -> k2));
        OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"validatecancel", (String)"ifm_transhandlebill", (Object[])transBills.stream().map(o -> o.getLong("id")).toArray(), (OperateOption)OperateOption.create());
        List errorInfos = result.getAllErrorOrValidateInfo();
        for (IOperateInfo errorInfo : errorInfos) {
            Long deductioId = detailToTransMap.get(errorInfo.getPkValue());
            this.addErrorMessage(extendeMap.get(deductioId), ResManager.loadKDString((String)"\u5173\u8054\u7684\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355%s", (String)"DeductionUnAuditValidator_2", (String)"tmc-ifm-business", (Object[])new Object[]{errorInfo.getMessage()}));
        }
    }

    private void checkRecTranBills(List<Long> checkRecTransBills, Map<Long, ExtendedDataEntity> extendeMap) {
        DynamicObjectCollection transBills = QueryServiceHelper.query((String)"ifm_rectransbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", checkRecTransBills), new QFilter("sourcebilltype", "=", (Object)"ifm_deduction"), new QFilter("paidstatus", "=", (Object)RecTransPayStatusEnum.PAID.getValue())});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)transBills)) {
            return;
        }
        Map<Long, Long> detailToTransMap = transBills.stream().collect(Collectors.toMap(o -> o.getLong("id"), v -> v.getLong("sourcebillid"), (k1, k2) -> k2));
        OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"validatecancel", (String)"ifm_rectransbill", (Object[])transBills.stream().map(o -> o.getLong("id")).toArray(), (OperateOption)OperateOption.create());
        List errorInfos = result.getAllErrorOrValidateInfo();
        for (IOperateInfo errorInfo : errorInfos) {
            Long deductioId = detailToTransMap.get(errorInfo.getPkValue());
            this.addErrorMessage(extendeMap.get(deductioId), ResManager.loadKDString((String)"\u5173\u8054\u7684\u6536\u6b3e\u8bb0\u8d26\u4e2d\u5fc3%s", (String)"DeductionUnAuditValidator_3", (String)"tmc-ifm-business", (Object[])new Object[]{errorInfo.getMessage()}));
        }
    }

    @Override
    protected void checkJournal(Map<Long, ExtendedDataEntity> idEntityMap, String entityname, List<Long> billIdsForCheckJournal) {
        if (!billIdsForCheckJournal.isEmpty()) {
            Map invalidMap = JournalBookHelper.validateBeforeCancel((String)entityname, billIdsForCheckJournal);
            for (Map.Entry entry : invalidMap.entrySet()) {
                this.addErrorMessage(idEntityMap.get(entry.getKey()), (String)entry.getValue());
            }
        }
    }
}

