/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deposit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositBizDealAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("releasetype");
        selector.add("amount");
        selector.add("finbillno");
        selector.add("applytype");
        selector.add("redeemdate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            String applyType = extData.getDataEntity().getString("applytype");
            if (!StringUtils.equals((CharSequence)applyType, (CharSequence)"release")) continue;
            this.validateReleaseAmt(extData);
            this.validateRedeemDate(extData);
        }
    }

    private void validateReleaseAmt(ExtendedDataEntity extData) {
        DynamicObject bizDeal = extData.getDataEntity();
        BigDecimal amount = bizDeal.getBigDecimal("amount");
        DynamicObject dptBillF7 = bizDeal.getDynamicObject("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)dptBillF7)) {
            return;
        }
        DynamicObject dptBill = TmcDataServiceHelper.loadSingle((Object)dptBillF7.getPkValue(), (String)"cim_deposit", (String)"billstatus,surplusamount");
        if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)dptBill.getString("billstatus"))) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u975e\u5ba1\u6838\u72b6\u6001\u7684\u5b58\u6b3e\u5355\u4e0d\u5141\u8bb8\u89e3\u6d3b\u3002", (String)"DepositBizDealAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        BigDecimal surplusAmount = dptBill.getBigDecimal("surplusamount");
        if (null == amount || null == surplusAmount) {
            return;
        }
        if (surplusAmount.compareTo(amount) < 0) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u7684\u89e3\u6d3b\u91d1\u989d\u5927\u4e8e\u53ef\u89e3\u6d3b\u91d1\u989d\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"DepositBizDealAuditValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateRedeemDate(ExtendedDataEntity extData) {
        DynamicObject depositBizDeal = extData.getDataEntity();
        DynamicObject depositBill = depositBizDeal.getDynamicObject("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        Date lastRedeemDate = (depositBill = TmcDataServiceHelper.loadSingle((String)"ifm_deposit", (String)"lastredeemdate", (QFilter[])new QFilter[]{new QFilter("id", "=", depositBill.getPkValue())})).getDate("lastredeemdate");
        if (EmptyUtil.isEmpty((Object)lastRedeemDate)) {
            return;
        }
        if (lastRedeemDate.compareTo(depositBizDeal.getDate("redeemdate")) >= 0) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u65e5\u671f\u8981\u5927\u4e8e\u5b58\u6b3e\u5355\u7684\u4e0a\u6b21\u89e3\u6d3b\u65e5\u671f\u3002", (String)"DepositBizDealAuditValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

