/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deposit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositBizDealSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("interesttype");
        selector.add("settleaccount");
        selector.add("finaccount");
        selector.add("finaccountf7");
        selector.add("intdate");
        selector.add("term");
        selector.add("expiredate");
        selector.add("demandrate");
        selector.add("basis");
        selector.add("investvarieties");
        selector.add("expireredeposit");
        selector.add("expiredate");
        selector.add("prenoticeday");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("ratesign");
        selector.add("ratefloatpoint");
        selector.add("rateadjuststyle");
        selector.add("amount");
        selector.add("redeemdate");
        selector.add("releasetype");
        selector.add("isrevenue");
        selector.add("applytype");
        selector.add("releasetype");
        selector.add("expireredeposit");
        selector.add("isrevenue");
        selector.add("finbillno");
        selector.add("demandrate");
        selector.add("predictinstamt");
        selector.add("redepositamount");
        selector.add("surplusamount");
        selector.add("realrevenue");
        selector.add("revenuesche");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            String applyType = extData.getDataEntity().getString("applytype");
            if (StringUtils.equals((CharSequence)applyType, (CharSequence)"deposit")) {
                this.doDepositValidate(extData);
                continue;
            }
            if (StringUtils.equals((CharSequence)applyType, (CharSequence)"release")) {
                this.doReleaseValidate(extData);
                continue;
            }
            this.doRevenueValidate(extData);
        }
    }

    private void doDepositValidate(ExtendedDataEntity extData) {
        this.validateDptTypeMustInput(extData);
        this.validateSameAccount(extData);
    }

    private void validateDptTypeMustInput(ExtendedDataEntity extData) {
        DynamicObject revenueProject;
        String interestType;
        DynamicObject investVarieties;
        DynamicObject bizDealBill = extData.getDataEntity();
        StringJoiner sj = new StringJoiner(",");
        if (EmptyUtil.isEmpty((Object)bizDealBill.get("settleaccount"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u6d3b\u671f\u8d26\u6237\u201d", (String)"DepositBizDealSubmitValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)bizDealBill.get("finaccount"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u8d26\u6237\u201d", (String)"DepositBizDealSubmitValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)bizDealBill.get("intdate"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u8d77\u606f\u65e5\u671f\u201d", (String)"DepositBizDealSubmitValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (null == bizDealBill.getBigDecimal("demandrate")) {
            sj.add(ResManager.loadKDString((String)"\u201c\u6d3b\u671f\u5229\u7387\uff08%\uff09\u201d", (String)"DepositBizDealSubmitValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)bizDealBill.get("basis"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u8ba1\u606f\u57fa\u51c6\u201d", (String)"DepositBizDealSubmitValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (InvestTypeEnum.isFixed((String)(investVarieties = bizDealBill.getDynamicObject("investvarieties")).getString("investtype"))) {
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("term"))) {
                sj.add(ResManager.loadKDString((String)"\u201c\u671f\u9650\uff08ymd\uff09\u201d", (String)"DepositBizDealSubmitValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("expiredate"))) {
                sj.add(ResManager.loadKDString((String)"\u201c\u5230\u671f\u65e5\u671f\u201d", (String)"DepositBizDealSubmitValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        } else if (EmptyUtil.isEmpty((Object)bizDealBill.get("prenoticeday"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u63d0\u524d\u901a\u77e5\u5929\u6570\u201d", (String)"DepositBizDealSubmitValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)(interestType = bizDealBill.getString("interesttype")), (CharSequence)"fixed")) {
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("interestrate"))) {
                sj.add(ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u5229\u7387\uff08%\uff09\u201d", (String)"DepositBizDealSubmitValidator_8", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        } else {
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("referencerate"))) {
                sj.add(ResManager.loadKDString((String)"\u201c\u53c2\u8003\u5229\u7387\u201d", (String)"DepositBizDealSubmitValidator_9", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("ratesign")) || null == bizDealBill.get("ratefloatpoint")) {
                sj.add(ResManager.loadKDString((String)"\u201c\u5229\u7387\u6d6e\u52a8\u57fa\u70b9\u201d", (String)"DepositBizDealSubmitValidator_10", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("rateadjuststyle"))) {
                sj.add(ResManager.loadKDString((String)"\u201c\u5229\u7387\u91cd\u7f6e\u65b9\u5f0f\u201d", (String)"DepositBizDealSubmitValidator_11", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
        if (EmptyUtil.isEmpty((DynamicObject)(revenueProject = bizDealBill.getDynamicObject("revenuesche")))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u6536\u76ca\u65b9\u6848\u201d", (String)"DepositBizDealSubmitValidator_24", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (sj.length() > 0) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"DepositBizDealSubmitValidator_12", (String)"tmc-ifm-business", (Object[])new Object[]{sj.toString()}));
        }
    }

    private void validateSameAccount(ExtendedDataEntity extData) {
        DynamicObject depositBill = extData.getDataEntity();
        DynamicObject finAccount = depositBill.getDynamicObject("finaccountf7");
        DynamicObject settleAccount = depositBill.getDynamicObject("settleaccount");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{finAccount, settleAccount})) {
            return;
        }
        if (settleAccount.getPkValue().equals(finAccount.getPkValue())) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u8d26\u6237\u548c\u6d3b\u671f\u8d26\u6237\u4e0d\u80fd\u76f8\u540c", (String)"DepositBillSubmitValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void doReleaseValidate(ExtendedDataEntity extData) {
        this.validateRelTypeMustInput(extData);
        this.validateReleaseAmt(extData);
        this.validateRedeemDate(extData);
    }

    private void doRevenueValidate(ExtendedDataEntity extData) {
        DynamicObject bizDealBill = extData.getDataEntity();
        BigDecimal realRevenue = bizDealBill.getBigDecimal("realrevenue");
        if (EmptyUtil.isEmpty((BigDecimal)realRevenue)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9e\u9645\u6536\u76ca\u201d", (String)"DepositBizDealSubmitValidator_23", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateRelTypeMustInput(ExtendedDataEntity extData) {
        String expireRedeposit;
        DynamicObject bizDealBill = extData.getDataEntity();
        StringJoiner sj = new StringJoiner(",");
        if (EmptyUtil.isEmpty((Object)bizDealBill.get("amount"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u89e3\u6d3b\u91d1\u989d\u201d", (String)"DepositBizDealSubmitValidator_13", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)bizDealBill.get("redeemdate"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u89e3\u6d3b\u65e5\u671f\u201d", (String)"DepositBizDealSubmitValidator_14", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)bizDealBill.get("releasetype"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u89e3\u6d3b\u7c7b\u578b\u201d", (String)"DepositBizDealSubmitValidator_15", (String)"tmc-ifm-business", (Object[])new Object[0]));
        } else if (EmptyUtil.isEmpty((Object)bizDealBill.get("expireredeposit")) && StringUtils.equals((CharSequence)"expire", (CharSequence)bizDealBill.getString("releasetype"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u5230\u671f\u7eed\u5b58\u201d", (String)"DepositBizDealSubmitValidator_16", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (bizDealBill.getBoolean("isrevenue")) {
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("demandrate"))) {
                sj.add(ResManager.loadKDString((String)"\u201c\u6d3b\u671f\u5229\u7387\uff08%\uff09\u201d", (String)"DepositBizDealSubmitValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("predictinstamt"))) {
                sj.add(ResManager.loadKDString((String)"\u201c\u6d4b\u7b97\u6536\u76ca\u201d", (String)"DepositBizDealSubmitValidator_17", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)bizDealBill.get("realrevenue"))) {
                sj.add(ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u6536\u76ca\u201d", (String)"DepositBizDealSubmitValidator_18", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
        if ((StringUtils.equals((CharSequence)(expireRedeposit = bizDealBill.getString("expireredeposit")), (CharSequence)"principalredeposit") || StringUtils.equals((CharSequence)expireRedeposit, (CharSequence)"principalintredeposit")) && EmptyUtil.isEmpty((Object)bizDealBill.get("redepositamount"))) {
            sj.add(ResManager.loadKDString((String)"\u201c\u5b58\u6b3e\u7eed\u5b58\u91d1\u989d\u201d", (String)"DepositBizDealSubmitValidator_19", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        if (sj.length() > 0) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"DepositBizDealSubmitValidator_12", (String)"tmc-ifm-business", (Object[])new Object[]{sj.toString()}));
        }
    }

    private void validateReleaseAmt(ExtendedDataEntity extData) {
        DynamicObject bizDeal = extData.getDataEntity();
        String releaseType = bizDeal.getString("releasetype");
        BigDecimal amount = bizDeal.getBigDecimal("amount");
        DynamicObject dptBillF7 = bizDeal.getDynamicObject("finbillno");
        DynamicObject dptBill = TmcDataServiceHelper.loadSingle((Object)dptBillF7.getPkValue(), (String)"cim_deposit", (String)"surplusamount");
        BigDecimal surplusAmount = dptBill.getBigDecimal("surplusamount");
        if (null == amount || null == surplusAmount) {
            return;
        }
        if (surplusAmount.compareTo(amount) < 0) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u7684\u89e3\u6d3b\u91d1\u989d\u5927\u4e8e\u53ef\u89e3\u6d3b\u91d1\u989d\uff0c\u63d0\u4ea4\u5931\u8d25\u3002", (String)"DepositBizDealSubmitValidator_20", (String)"tmc-ifm-business", (Object[])new Object[0]));
        } else if (surplusAmount.compareTo(amount) != 0 && StringUtils.equals((CharSequence)releaseType, (CharSequence)"expire")) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5230\u671f\u89e3\u6d3b\u65f6\uff0c\u89e3\u6d3b\u91d1\u989d\u9700\u7b49\u4e8e\u53ef\u89e3\u6d3b\u91d1\u989d\u3002", (String)"DepositBizDealSubmitValidator_21", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return;
        }
    }

    private void validateRedeemDate(ExtendedDataEntity extData) {
        DynamicObject depositBizDeal = extData.getDataEntity();
        DynamicObject depositBill = depositBizDeal.getDynamicObject("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        Date lastRedeemDate = (depositBill = TmcDataServiceHelper.loadSingle((String)"ifm_deposit", (String)"lastredeemdate", (QFilter[])new QFilter[]{new QFilter("id", "=", depositBill.getPkValue())})).getDate("lastredeemdate");
        if (EmptyUtil.isEmpty((Object)lastRedeemDate)) {
            return;
        }
        if (lastRedeemDate.compareTo(depositBizDeal.getDate("redeemdate")) >= 0) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u65e5\u671f\u8981\u5927\u4e8e\u5b58\u6b3e\u5355\u7684\u4e0a\u6b21\u89e3\u6d3b\u65e5\u671f\u3002", (String)"DepositBizDealSubmitValidator_22", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

