/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deposit;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositBizDealUnAuditValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            String billStatus;
            DynamicObject bizDealBill = extData.getDataEntity();
            String targetBillName = this.getTargetBillName(bizDealBill);
            DynamicObject targetBill = TmcBotpHelper.getTargetBill((String)"ifm_bizdealbill_deposit", (Object)bizDealBill.getPkValue(), (String)targetBillName);
            if (EmptyUtil.isEmpty((DynamicObject)targetBill) || StringUtils.equals((CharSequence)(billStatus = targetBill.getString("billstatus")), (CharSequence)BillStatusEnum.SAVE.getValue())) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u72b6\u6001\u4e3a\u6682\u5b58\u65f6\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DepositBizDealUnAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private String getTargetBillName(DynamicObject bizDealBill) {
        String applyType = bizDealBill.getString("applytype");
        String investType = bizDealBill.getDynamicObject("investvarieties").getString("investtype");
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"deposit") && InvestTypeEnum.isFixed((String)investType)) {
            return "ifm_deposit";
        }
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"deposit") && InvestTypeEnum.isNotice((String)investType)) {
            return "ifm_notice_deposit";
        }
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"release") && InvestTypeEnum.isFixed((String)investType)) {
            return "ifm_release";
        }
        if (StringUtils.equals((CharSequence)applyType, (CharSequence)"release") && InvestTypeEnum.isNotice((String)investType)) {
            return "ifm_notice_release";
        }
        return "";
    }
}

