/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.deposit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositBizDealUnChargeBackValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List sourceBillNos = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(v -> v.getString("sourcebillno")).collect(Collectors.toList());
        Object[] existBizDeals = TmcDataServiceHelper.load((String)"ifm_bizdealbill_deposit", (String)"billno,sourcebillno", (QFilter[])new QFilter[]{new QFilter("sourcebillno", "in", sourceBillNos), new QFilter("bizstatus", "!=", (Object)"D")});
        if (EmptyUtil.isEmpty((Object[])existBizDeals)) {
            return;
        }
        Map sourceBillMap = Arrays.stream(existBizDeals).collect(Collectors.toMap(v -> v.getString("sourcebillno"), r -> r, (o1, o2) -> o1, HashMap::new));
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject bizDeal = extendedDataEntity.getDataEntity();
            DynamicObject existBill = (DynamicObject)sourceBillMap.get(bizDeal.getString("sourcebillno"));
            if (!EmptyUtil.isNoEmpty((DynamicObject)existBill) || existBill.getPkValue().equals(bizDeal.getPkValue())) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u5b58\u5728\u975e\u5df2\u9000\u5355\u72b6\u6001\u7684\u53d7\u7406\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositBizDealUnChargeBackValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

