/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.exrate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.TransBillHelper;

public class ExchangeRateValidator
extends AbstractTmcBizOppValidator {
    public Set<String> preparePropertys() {
        Set sel = super.preparePropertys();
        sel.add("currency");
        sel.add("basecurrency");
        sel.add("exratetable");
        sel.add("scorg");
        sel.add("exrate");
        sel.add("bizdate");
        sel.add("quotation");
        sel.add("localamt");
        sel.add("receivecurrency");
        sel.add("receiveamount");
        sel.add("actrecamt");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        HashMap<Long, Boolean> baseCurRateMap = new HashMap<Long, Boolean>(dataEntitys.length);
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject scorg = bill.getDynamicObject("scorg");
            if (EmptyUtil.isEmpty((DynamicObject)scorg)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ExchangeRateValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            long orgId = scorg.getLong("id");
            boolean checkExRate = this.checkBaseCurrencyRate(baseCurRateMap, orgId);
            this.getOption().setVariableValue("basecurrencyrate", String.valueOf(checkExRate));
            String orgName = scorg.getString("name");
            DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
            DynamicObject exTable = bill.getDynamicObject("exratetable");
            DynamicObject systemStatusCtrol = null;
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{baseCurrency, exTable})) {
                systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol((long)scorg.getLong("id"));
                if (checkExRate && systemStatusCtrol == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u7ec4\u7ec7\uff08%s\uff09\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u83b7\u53d6\u672c\u4f4d\u5e01\u3001\u6c47\u7387\u8868\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u51fa\u7eb3\u521d\u59cb\u5316\u914d\u7f6e\u3002", (String)"ExchangeRateValidator_1", (String)"tmc-ifm-business", (Object[])new Object[]{orgName}));
                    continue;
                }
            }
            if (EmptyUtil.isEmpty((DynamicObject)baseCurrency) && systemStatusCtrol != null) {
                baseCurrency = systemStatusCtrol.getDynamicObject("standardcurrency");
                this.checkSystemStatus(dataEntity, baseCurrency, "basecurrency", orgName, checkExRate);
            }
            if (EmptyUtil.isEmpty((DynamicObject)exTable) && systemStatusCtrol != null) {
                exTable = systemStatusCtrol.getDynamicObject("exratetable");
                this.checkSystemStatus(dataEntity, exTable, "exratetable", orgName, checkExRate);
            }
            BigDecimal exRate = bill.getBigDecimal("exrate");
            String currencyProp = "currency";
            if ("ifm_deduction".equals(bill.getDynamicObjectType().getName())) {
                currencyProp = "receivecurrency";
            }
            DynamicObject currency = bill.getDynamicObject(currencyProp);
            String quataTion = bill.getString("quotation");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRate, quataTion}) || currency == null || baseCurrency == null || currency.getPkValue().equals(baseCurrency.getPkValue())) continue;
            Map exchangeRateMap = TransBillHelper.getExchangeRateMap((DynamicObject)currency, (DynamicObject)baseCurrency, (DynamicObject)exTable, (Date)bill.getDate("bizdate"));
            if (EmptyUtil.isEmpty((Object)exchangeRateMap) || EmptyUtil.isEmpty(exchangeRateMap.get("exchangeRate"))) {
                if (!checkExRate) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5151%2$s\u6c47\u7387\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6c47\u7387\u8868\u4e2d\u914d\u7f6e\u3002", (String)"ExchangeRateValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]), currency.getString("name"), baseCurrency.getString("name")));
                continue;
            }
            this.getOption().setVariableValue("exrate", String.valueOf(exchangeRateMap.get("exchangeRate")));
            boolean isIndirect = (Boolean)exchangeRateMap.get("quoteType");
            this.getOption().setVariableValue("quotation", isIndirect ? "1" : "0");
        }
    }

    private void checkSystemStatus(ExtendedDataEntity dataEntity, DynamicObject initVal, String prop, String orgName, boolean checkExRate) {
        if (EmptyUtil.isEmpty((DynamicObject)initVal)) {
            String errMsg = ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u7ec4\u7ec7\uff08%s\uff09\u521d\u59cb\u5316\u672c\u4f4d\u5e01\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u51fa\u7eb3\u521d\u59cb\u5316\u914d\u7f6e\u3002", (String)"ExchangeRateValidator_3", (String)"tmc-ifm-business", (Object[])new Object[]{orgName});
            if ("exratetable".equals(prop)) {
                errMsg = ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u7ec4\u7ec7\uff08%s\uff09\u521d\u59cb\u5316\u6c47\u7387\u8868\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u51fa\u7eb3\u521d\u59cb\u5316\u914d\u7f6e\u3002", (String)"ExchangeRateValidator_4", (String)"tmc-ifm-business", (Object[])new Object[]{orgName});
            }
            if (checkExRate) {
                this.addErrorMessage(dataEntity, errMsg);
            }
        } else {
            this.getOption().setVariableValue(prop, String.valueOf(initVal.getPkValue()));
        }
    }

    private boolean checkBaseCurrencyRate(Map<Long, Boolean> baseCurRateMap, Long orgId) {
        if (baseCurRateMap.containsKey(orgId)) {
            return baseCurRateMap.get(orgId);
        }
        boolean isBaseCurrencyRate = TransBillHelper.isBaseCurrencyRate((long)orgId);
        baseCurRateMap.put(orgId, isBaseCurrencyRate);
        return isBaseCurrencyRate;
    }
}

