/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.extintobject;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.validator.intobject.IntObjectBaseSaveValidator;

public class ExtIntObjectSaveValidator
extends IntObjectBaseSaveValidator {
    @Override
    public List<String> getSelector() {
        List<String> selector = super.getSelector();
        selector.add("accountorg");
        selector.add("intobject");
        selector.add("relateitem");
        selector.add("entry");
        selector.add("select");
        selector.add("asstactitem");
        selector.add("detailid");
        selector.add("startintdate");
        selector.add("lastintdate");
        return selector;
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObject extIntObject = BusinessDataServiceHelper.loadSingle((String)"ifm_extintobject", (String)"id,lastintdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getLong("id"))});
            if (EmptyUtil.isEmpty((DynamicObject)extIntObject)) {
                Date startIntdate = data.getDate("startintdate");
                Date lastIntdate = data.getDate("lastintdate");
                if (lastIntdate.after(startIntdate)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u6b21\u7ed3\u606f\u65e5\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u65e5\u671f\u3002", (String)"ExtIntObjectSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            }
            if (!this.validateDuplicate(data)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u8be5\u79d1\u76ee\u7684\u8ba1\u606f\u5bf9\u8c61\uff0c\u8bf7\u786e\u8ba4\u518d\u4fdd\u5b58\u3002", (String)"ExtIntObjectSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            super.validateIntEntries(extendedDataEntity);
            this.validateAccountEntry(extendedDataEntity, data);
        }
    }

    private void validateAccountEntry(ExtendedDataEntity extendedDataEntity, DynamicObject extIntObject) {
        DynamicObjectCollection entry = extIntObject.getDynamicObjectCollection("entry");
        boolean relateItem = extIntObject.getBoolean("relateitem");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry) || !relateItem) {
            return;
        }
        List selectDetails = entry.stream().filter(v -> v.getBoolean("select")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(selectDetails)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u9879\u76ee\u7c7b\u578b\u3002", (String)"ExtIntObjectSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        } else if (selectDetails.size() > 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u9879\u76ee\u7c7b\u578b\u5206\u5f55\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u3002", (String)"ExtIntObjectSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
        } else {
            DynamicObject selectDetail = (DynamicObject)selectDetails.get(0);
            if (EmptyUtil.isEmpty((Object)selectDetail.get("detailid"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u9879\u76ee\u3002", (String)"ExtIntObjectSaveValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }

    private boolean validateDuplicate(DynamicObject extIntObject) {
        Object accountOrgId = extIntObject.getDynamicObject("accountorg").getPkValue();
        DynamicObject intObject = extIntObject.getDynamicObject("intobject");
        if (EmptyUtil.isEmpty((DynamicObject)intObject)) {
            return true;
        }
        Object intObjectId = intObject.getPkValue();
        boolean relateItem = extIntObject.getBoolean("relateitem");
        DynamicObjectCollection entry = extIntObject.getDynamicObjectCollection("entry");
        Object[] duplicateObjs = TmcDataServiceHelper.load((String)"ifm_extintobject", (String)"org,accountorg,intobject,relateitem,entry,entry.asstactitem,entry.detailid", (QFilter[])new QFilter[]{new QFilter("accountorg", "=", accountOrgId), new QFilter("intobject", "=", intObjectId), new QFilter("relateitem", "=", (Object)relateItem), new QFilter("id", "!=", extIntObject.getPkValue())});
        if (EmptyUtil.isEmpty((Object[])duplicateObjs)) {
            return true;
        }
        if (!relateItem || EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            return false;
        }
        List selectDetails = entry.stream().filter(v -> v.getBoolean("select")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(selectDetails)) {
            return true;
        }
        DynamicObject selectEntry = (DynamicObject)selectDetails.get(0);
        long assItemId = selectEntry.getDynamicObject("asstactitem").getLong("id");
        long detailId = selectEntry.getLong("detailid");
        for (Object duplicateObj : duplicateObjs) {
            DynamicObjectCollection duplicateEntry = duplicateObj.getDynamicObjectCollection("entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)duplicateEntry)) continue;
            DynamicObject duplicateRow = (DynamicObject)duplicateEntry.get(0);
            long duplicateAssItemId = duplicateRow.getDynamicObject("asstactitem").getLong("id");
            long duplicateDetailId = duplicateRow.getLong("detailid");
            if (assItemId != duplicateAssItemId || detailId != duplicateDetailId) continue;
            return false;
        }
        return true;
    }
}

