/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.inneracct;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.validator.helper.InnerAcctBusHelper;
import kd.tmc.ifm.enums.InnerAcctStatusEnum;
import kd.tmc.ifm.resource.IfmBizResource;

public class InnerAcctCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("acctstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        for (ExtendedDataEntity data : dataEntity) {
            boolean journalIsCheck;
            Map operationVariable;
            DynamicObject innerAcct = data.getDataEntity();
            if (!InnerAcctStatusEnum.isNormal((String)innerAcct.getString("acctstatus"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u6b63\u5e38\u72b6\u6001\u7684\u8d26\u6237\u53ef\u4ee5\u9500\u6237\u3002", (String)"InnerAcctPreCloseValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject bankAcct = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)"id,currency,company", (QFilter[])new QFilter("inneracct.id", "=", (Object)innerAcct.getLong("id")).toArray());
            if (bankAcct == null) {
                this.addErrorMessage(data, ifmBizResource.checkBankAcctNull());
                continue;
            }
            long companyId = bankAcct.getDynamicObject("company").getLong("id");
            boolean isNeedCheck = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.AM.getId(), (long)companyId, (String)"bankacctclosectrl");
            if (!isNeedCheck) continue;
            String checkBillParams = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.AM.getId(), (long)companyId, (String)"bankacctclosectrlitem");
            long bankAcctId = bankAcct.getLong("id");
            String validataMsg = InnerAcctBusHelper.getValidataMsg("cas_paybill", bankAcctId, checkBillParams, "pay");
            if (EmptyUtil.isNoEmpty((String)validataMsg)) {
                this.addErrorMessage(data, ifmBizResource.getCloseacctExistpbill() + validataMsg + ifmBizResource.getCloseacctOpperror());
            }
            if (EmptyUtil.isNoEmpty((String)(validataMsg = InnerAcctBusHelper.getValidataMsg("cas_recbill", bankAcctId, checkBillParams, "rec")))) {
                this.addErrorMessage(data, ifmBizResource.getCloseacctExistrbill() + validataMsg + ifmBizResource.getCloseacctOpperror());
            }
            if (EmptyUtil.isNoEmpty((String)(validataMsg = InnerAcctBusHelper.getValidataMsg("cas_agentpaybill", bankAcctId, checkBillParams, "agent")))) {
                this.addErrorMessage(data, ifmBizResource.getCloseacctExistagentpbill() + validataMsg + ifmBizResource.getCloseacctOpperror());
            }
            if (!(operationVariable = this.getOption().getVariables()).containsKey("closereason")) continue;
            boolean isValidata = InnerAcctBusHelper.validataBalance(bankAcct, checkBillParams);
            if (!isValidata) {
                this.addWarningMessage(data, ifmBizResource.getTipCasamt());
            }
            if (!checkBillParams.contains("journalcheck") || (journalIsCheck = CasBusinessHelper.journalIsCheck((DynamicObject)bankAcct))) continue;
            this.addWarningMessage(data, ifmBizResource.getTipCascheck());
        }
    }
}

