/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.interest;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractCIntBillBatchOnWayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("biztype");
        selector.add("begindate");
        selector.add("intobject");
        selector.add("batchno");
        selector.add("interesttype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity intExtend : dataEntity) {
            DynamicObject intBatchBill = intExtend.getDataEntity();
            String interestType = intBatchBill.getString("interesttype");
            if (!StringUtils.equals((CharSequence)interestType, (CharSequence)"currentint") && this.isPreInt()) continue;
            DynamicObjectCollection batchEntryIntBills = intBatchBill.getDynamicObjectCollection("entry");
            ArrayList<Object> intObjectIds = new ArrayList<Object>(batchEntryIntBills.size());
            for (DynamicObject intBill : batchEntryIntBills) {
                intObjectIds.add(intBill.getDynamicObject("intobject").getPkValue());
            }
            this.validateOnWayBill(intExtend, intObjectIds);
        }
    }

    protected void validateOnWayBill(ExtendedDataEntity intExtend, List<Object> intObjectIds) {
        QFilter qfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("entry.intobject", "in", intObjectIds));
        if (EmptyUtil.isNoEmpty((Object)intExtend.getDataEntity().getPkValue())) {
            qfilter.and(new QFilter("id", "!=", intExtend.getDataEntity().getPkValue()));
        }
        String bizType = this.isPreInt() ? "preint" : "currentint";
        qfilter.and(new QFilter("biztype", "=", (Object)bizType));
        DynamicObjectCollection batchEntryBills = QueryServiceHelper.query((String)"ifm_intbill_batch_current", (String)"entry.id,entry.intobject", (QFilter[])qfilter.toArray());
        ArrayList illegalBillIds = new ArrayList();
        batchEntryBills.stream().filter(v -> intObjectIds.contains(v.get("entry.intobject"))).forEach(v -> illegalBillIds.add(v.getLong("entry.intobject")));
        if (!CollectionUtils.isEmpty(illegalBillIds)) {
            DynamicObjectCollection inneraccts = QueryServiceHelper.query((String)"ifm_intobject", (String)"name", (QFilter[])new QFilter("id", "in", illegalBillIds).toArray());
            StringJoiner sj = new StringJoiner("\uff0c");
            inneraccts.stream().forEach(v -> sj.add(v.getString("name")));
            this.addErrorMessage(intExtend, this.getExistOnWayDataTip(sj.toString()));
        }
    }

    public String getExistOnWayDataTip(String loanNum) {
        return ResManager.loadKDString((String)"\u8ba1\u606f\u5bf9\u8c61\u3010%s\u3011\u5b58\u5728\u6b63\u5728\u5904\u7406\u7684\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"IntOnWayValidator_0", (String)"tmc-ifm-business", (Object[])new Object[]{loanNum});
    }

    public abstract boolean isPreInt();
}

