/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.interest;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.PreIntWayEnum;
import kd.tmc.ifm.enums.WriteOffStatusEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class CurrentIntBillUnWriteOffValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("settlecenter");
        selector.add("intobject");
        selector.add("writeoffstatus");
        selector.add("billstatus");
        selector.add("biztype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            if (!this.validateWriteOffParam(extendedDataEntity)) continue;
            this.validateStatus(extendedDataEntity);
            this.validateOrder(extendedDataEntity);
        }
    }

    private boolean validateWriteOffParam(ExtendedDataEntity extendedDataEntity) {
        DynamicObject currentInt = extendedDataEntity.getDataEntity();
        DynamicObject settleCenter = currentInt.getDynamicObject("settlecenter");
        String preIntWay = SettleIntWriteOffHelper.getPreIntWay((DynamicObject)settleCenter);
        if (EmptyUtil.isEmpty((String)preIntWay)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u7ed3\u7b97\u4e2d\u5fc3\u9884\u63d0\u65b9\u6cd5", (String)"CurrentPreIntBillRedWriteOffValidate_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        if (!StringUtils.equals((CharSequence)PreIntWayEnum.QECXF.getValue(), (CharSequence)preIntWay)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ed3\u7b97\u4e2d\u5fc3\u9884\u63d0\u65b9\u6cd5\u4e3a\uff1a\u201c\u5168\u989d\u51b2\u9500\u6cd5\u201d", (String)"CurrentIntBillWriteOffValidate_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateStatus(ExtendedDataEntity extendedDataEntity) {
        DynamicObject interestBill = extendedDataEntity.getDataEntity();
        String billStatus = interestBill.getString("billstatus");
        String writeOffStatus = interestBill.getString("writeoffstatus");
        if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue()) || !StringUtils.equals((CharSequence)writeOffStatus, (CharSequence)WriteOffStatusEnum.WRITEOFF.getValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u5df2\u51b2\u9500\u5355\u636e\u5141\u8bb8\u53cd\u51b2\u9500\u3002", (String)"CurrentIntBillUnWriteOffValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private void validateOrder(ExtendedDataEntity extendedDataEntity) {
        DynamicObject interestBill = extendedDataEntity.getDataEntity();
        DynamicObject intObject = interestBill.getDynamicObject("intobject");
        if (null == intObject) {
            return;
        }
        QFilter filter = new QFilter("intobject", "=", intObject.getPkValue());
        filter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.WRITEOFF.getValue()));
        filter.and(new QFilter("biztype", "=", (Object)interestBill.getString("biztype")));
        Object[] writeOffedBills = TmcDataServiceHelper.load((String)"ifm_currentintbill", (String)"id", (QFilter[])filter.toArray(), (String)"begindate desc");
        if (EmptyUtil.isNoEmpty((Object[])writeOffedBills) && !writeOffedBills[0].getPkValue().equals(interestBill.getPkValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u987a\u5e8f\u53cd\u51b2\u9500\u3002", (String)"CurrentIntBillUnWriteOffValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

