/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.interest;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.ifm.enums.EntityEnum;
import kd.tmc.ifm.helper.BizDealHelper;
import kd.tmc.ifm.resource.IfmBizResource;

public class LoanIntBillBatchunAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        for (ExtendedDataEntity intExtend : dataEntity) {
            DynamicObject intBatchBill = intExtend.getDataEntity();
            DynamicObjectCollection batchEntryIntBills = intBatchBill.getDynamicObjectCollection("entry");
            for (DynamicObject intBill : batchEntryIntBills) {
                Map downStreamBillMap = BFTrackerServiceHelper.findTargetBills((String)"cfm_interestbill", (Long[])new Long[]{intBill.getLong("id")});
                this.validateDownStreamInfo(downStreamBillMap, ifmBizResource, intExtend);
            }
        }
    }

    private void validateDownStreamInfo(Map<String, HashSet<Long>> downStreamBillMap, IfmBizResource ifmBizResource, ExtendedDataEntity ede) {
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, HashSet<Long>> entry : downStreamBillMap.entrySet()) {
            String entityName = entry.getKey();
            if (!EntityEnum.CAS_RECBILL.getValue().equals(entityName) && !EntityEnum.CAS_PAYBILL.getValue().equals(entityName)) continue;
            String existBillsMsg = BizDealHelper.findExistBillsMsg((IfmBizResource)ifmBizResource, (String)entityName, entry.getValue());
            msg.append(existBillsMsg);
        }
        if (msg.length() > 0) {
            msg.insert(0, ifmBizResource.getExistTargetBillError());
            this.addErrorMessage(ede, msg.toString());
        }
    }
}

