/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.intobject;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.IntObjectTypeEnum;

public class IntObjectBankBatchSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            if (!this.validateMustInput(extendedDataEntity)) continue;
            this.validateCurrency(extendedDataEntity);
            this.validateBankAcct(extendedDataEntity);
            this.validateIntDate(extendedDataEntity);
        }
    }

    private boolean validateMustInput(ExtendedDataEntity extendedDataEntity) {
        DynamicObject batchIntObject = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entry = batchIntObject.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"IntObjectBankBatchSaveValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        if (entry.stream().anyMatch(v -> Objects.isNull(v.get("intobject")) || Objects.isNull(v.get("currency")) || Objects.isNull(v.get("name")))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"IntObjectBankBatchSaveValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        DynamicObject referRate = batchIntObject.getDynamicObject("referrate");
        if (Objects.isNull(referRate)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u8003\u5229\u7387\u3002", (String)"IntObjectBankBatchSaveValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateCurrency(ExtendedDataEntity extendedDataEntity) {
        DynamicObject batchIntObject = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entry = batchIntObject.getDynamicObjectCollection("entryentity");
        Set currencyIds = entry.stream().map(v -> v.getDynamicObject("currency").getPkValue()).collect(Collectors.toSet());
        if (currencyIds.size() > 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e3b\u4f53\u4fe1\u606f\u4e2d\u7684\u94f6\u884c\u8d26\u6237\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"IntObjectBankBatchSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        } else {
            Object currId = batchIntObject.getDynamicObject("referrate").getDynamicObject("currency").getPkValue();
            if (!Objects.equals(currId, currencyIds.iterator().next())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53c3\u8003\u5229\u7387\u7684\u5e01\u79cd\u548c\u94f6\u884c\u8d26\u6237\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"IntObjectBankBatchSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateBankAcct(ExtendedDataEntity extendedDataEntity) {
        DynamicObject batchIntObject = extendedDataEntity.getDataEntity();
        DynamicObjectCollection entry = batchIntObject.getDynamicObjectCollection("entryentity");
        Set bankAcctIds = entry.stream().map(v -> v.getDynamicObject("intobject").getPkValue()).collect(Collectors.toSet());
        if (bankAcctIds.size() != entry.size()) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u9009\u62e9\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"IntObjectBankBatchSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
        DynamicObject currency = ((DynamicObject)entry.get(0)).getDynamicObject("currency");
        QFilter filter = new QFilter("intobject", "in", bankAcctIds);
        filter.and("currency", "=", currency.getPkValue());
        filter.and("biztype", "=", (Object)IntObjectTypeEnum.BANKACCT.getValue());
        DynamicObjectCollection intObjectFromDB = QueryServiceHelper.query((String)"ifm_bankacctintobject", (String)"intobject", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)intObjectFromDB)) {
            Map dataMap = entry.stream().map(v -> v.getDynamicObject("intobject")).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v.getString("number"), (o1, o2) -> o1, HashMap::new));
            String bankAcctNumbers = intObjectFromDB.stream().map(v -> (String)dataMap.get(v.get("intobject"))).filter(EmptyUtil::isNoEmpty).collect(Collectors.joining(","));
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237[%1$s]\u5df2\u5173\u8054\u5e01\u79cd\u4e3a[%2$s]\u7684\u8ba1\u606f\u5bf9\u8c61\u3002", (String)"IntObjectBankBatchSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]), bankAcctNumbers, currency.getString("name")));
        }
    }

    private void validateIntDate(ExtendedDataEntity extendedDataEntity) {
        DynamicObject batchIntObject = extendedDataEntity.getDataEntity();
        Date startDate = batchIntObject.getDate("startintdate");
        Date lastDate = batchIntObject.getDate("lastintdate");
        if (startDate != null && lastDate != null && lastDate.compareTo(startDate) > 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u6b21\u7ed3\u606f\u65e5\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u65e5\u671f", (String)"IntObjectBankBatchSaveValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

