/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.intobject;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.validator.intobject.IntObjectBaseSaveValidator;

public class IntObjectSaveValidator
extends IntObjectBaseSaveValidator {
    @Override
    public List<String> getSelector() {
        List<String> sels = super.getSelector();
        sels.add("intobject");
        sels.add("startintdate");
        sels.add("lastintdate");
        return sels;
    }

    @Override
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        DynamicObjectCollection innertAccts;
        HashSet innertAcctNums = new HashSet(16);
        Set innertAcctIds = Arrays.stream(dataEntity).map(o -> o.getDataEntity().getDynamicObject("intobject").getPkValue()).collect(Collectors.toSet());
        Object[] intObjects = BusinessDataServiceHelper.load((String)"ifm_intobject", (String)"id,intobject", (QFilter[])new QFilter[]{new QFilter("intobject", "in", innertAcctIds)});
        if (EmptyUtil.isNoEmpty((Object[])intObjects)) {
            Set innertNums = Arrays.stream(intObjects).map(o -> o.getDynamicObject("intobject").getString("number")).collect(Collectors.toSet());
            innertAcctNums.addAll(innertNums);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(innertAccts = QueryServiceHelper.query((String)"ifm_inneracct", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", innertAcctIds), new QFilter("isdrawobject", "=", (Object)"1")})))) {
            Set innertNums = innertAccts.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            innertAcctNums.addAll(innertNums);
        }
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Long acctCurrencyId;
            Long rateCurrencyId;
            DynamicObject referRate;
            DynamicObject data = extendedDataEntity.getDataEntity();
            DynamicObject intObj = data.getDynamicObject("intobject");
            String number = intObj.getString("number");
            DynamicObject intObject = BusinessDataServiceHelper.loadSingle((String)"ifm_intobject", (String)"id,inneracct,lastintdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getLong("id"))});
            if (EmptyUtil.isEmpty((DynamicObject)intObject) && innertAcctNums.contains(number)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237[%s]\u5df2\u5173\u8054\u8ba1\u606f\u5bf9\u8c61\u3002", (String)"IntObjectSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[]{number}));
            }
            Date startDate = data.getDate("startintdate");
            Date LastDate = data.getDate("lastintdate");
            DynamicObjectCollection current = null;
            if (EmptyUtil.isNoEmpty((DynamicObject)intObject)) {
                current = QueryServiceHelper.query((String)"ifm_intbill_batch_current", (String)"id,entry.intobject", (QFilter[])new QFilter[]{new QFilter("entry.intobject.id", "=", (Object)intObject.getLong("id"))});
            }
            if (EmptyUtil.isNoEmpty(current)) {
                if (LastDate.compareTo(intObject.getDate("lastintdate")) > 0) {
                    this.addWarningMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8ba1\u606f\u5bf9\u8c61\u5df2\u53c2\u4e0e\u8ba1\u606f\uff0c\u4fee\u6539\u7684\u4e0a\u6b21\u7ed3\u606f\u65e5\u53ef\u80fd\u5b58\u5728\u65ad\u606f\u3002", (String)"IntObjectSaveValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (LastDate.compareTo(intObject.getDate("lastintdate")) < 0) {
                    this.addWarningMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8ba1\u606f\u5bf9\u8c61\u5df2\u53c2\u4e0e\u8ba1\u606f\uff0c\u4fee\u6539\u7684\u4e0a\u6b21\u7ed3\u606f\u65e5\u53ef\u80fd\u5b58\u5728\u91cd\u606f\u3002", (String)"IntObjectSaveValidator_8", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            }
            if ((EmptyUtil.isEmpty((DynamicObject)intObject) || EmptyUtil.isEmpty(current)) && !this.skipCheckLastIntDate() && LastDate.compareTo(startDate) > 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u6b21\u7ed3\u606f\u65e5\u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u65e5\u671f\u3002", (String)"IntObjectSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if ((referRate = data.getDynamicObject("referrate")) != null && !(rateCurrencyId = Long.valueOf(data.getDynamicObject("referrate").getDynamicObject("currency").getLong("id"))).equals(acctCurrencyId = Long.valueOf(((DynamicObject)intObj.getDynamicObjectCollection("currency").get(0)).getDynamicObject("fbasedataid").getLong("id")))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u5b58\u6b3e\u5229\u7387\u7684\u5e01\u79cd\u548c\u5185\u90e8\u94f6\u884c\u8d26\u6237\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"IntObjectSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            super.validateIntEntries(extendedDataEntity);
            this.validateIsCallInterest(extendedDataEntity, intObj);
        }
    }

    private void validateIsCallInterest(ExtendedDataEntity extendedDataEntity, DynamicObject intObj) {
        DynamicObject bdAccount = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"inneracct", (QFilter[])new QFilter[]{new QFilter("id", "in", intObj.getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)bdAccount)) {
            return;
        }
        DynamicObject innerAcct = BusinessDataServiceHelper.loadSingle((String)"ifm_inneracct", (String)"interest", (QFilter[])new QFilter[]{new QFilter("id", "in", bdAccount.getDynamicObject("inneracct").getPkValue())});
        if (EmptyUtil.isNoEmpty((DynamicObject)innerAcct) && !innerAcct.getBoolean("interest")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u662f\u5426\u8ba1\u606f\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u7ed1\u5b9a\u5185\u90e8\u8ba1\u606f\u5bf9\u8c61\u3002", (String)"IntObjectSaveValidator_11", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }

    private boolean skipCheckLastIntDate() {
        return "Y".equals(this.getValidateContext().getOption().getVariableValue("_skip_check_lastintdate", "N"));
    }
}

