/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.ldproduct;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class LoanDepProductSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("servicecategory");
        selector.add("category");
        selector.add("productterm");
        selector.add("enable");
        selector.add("name");
        selector.add("currency");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            this.checkName(extendedDataEntity);
        }
    }

    private void checkName(ExtendedDataEntity extendedDataEntity) {
        DynamicObject product = extendedDataEntity.getDataEntity();
        QFilter nameFilter = new QFilter("name", "=", (Object)product.getLocaleString("name").getLocaleValue());
        QFilter exceptFilter = new QFilter("id", "!=", product.getPkValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        boolean exists = TmcDataServiceHelper.exists((String)"ifm_ldproduct", (QFilter[])nameFilter.and(exceptFilter).and(enableFilter).toArray());
        if (exists) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u7ecf\u4f7f\u7528\uff01", (String)"LoanDepProductSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

