/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.loanbill;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.EntityEnum;
import kd.tmc.ifm.helper.BizDealHelper;
import kd.tmc.ifm.resource.IfmBizResource;

public class IfmLoanBillUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billno");
        selector.add("creditortype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        IfmBizResource ifmBizResource = new IfmBizResource();
        for (ExtendedDataEntity targetDataEntity : dataEntity) {
            Map botpMap;
            DynamicObject loanBill = targetDataEntity.getDataEntity();
            String billNo = loanBill.getString("billno");
            if (EmptyUtil.isNoEmpty((String)billNo) && billNo.startsWith("D-")) {
                this.addErrorMessage(targetDataEntity, ifmBizResource.getUnAuditMsgJudgeBillSrc());
                continue;
            }
            String creditorType = loanBill.getString("creditortype");
            if (StringUtils.equals((CharSequence)creditorType, (CharSequence)"settlecenter") || (botpMap = BFTrackerServiceHelper.findTargetBills((String)"cfm_loanbill", (Long[])new Long[]{loanBill.getLong("id")})) == null || botpMap.size() <= 0) continue;
            StringBuilder msg = new StringBuilder();
            for (Map.Entry entry : botpMap.entrySet()) {
                String entityName = (String)entry.getKey();
                if (!EntityEnum.CAS_RECBILL.getValue().equals(entityName) && !EntityEnum.CAS_PAYBILL.getValue().equals(entityName)) continue;
                String existBillsMsg = BizDealHelper.findExistBillsMsg((IfmBizResource)ifmBizResource, (String)entityName, (HashSet)((HashSet)entry.getValue()));
                msg.append(existBillsMsg);
            }
            if (msg.length() > 0) {
                msg.insert(0, ifmBizResource.getExistTargetBillError());
            }
            if (!EmptyUtil.isNoEmpty((String)msg.toString())) continue;
            this.addErrorMessage(targetDataEntity, msg.toString());
        }
    }
}

