/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.payacceptancebill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.enums.TransTypeEnum;

public class PayAcceptanceSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        selector.add("billstatus");
        selector.add("sourcebilltype");
        selector.add("sourcebillid");
        selector.add("sourcebillnumber");
        selector.add("settletype");
        selector.add("transtype");
        selector.add("agentpayeraccount");
        selector.add("bankaccount");
        selector.add("actpayamt");
        selector.add("currency");
        selector.add("recaccbankname");
        selector.add("payeename");
        selector.add("payeebanknum");
        selector.add("paymentchannel");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String ifmAcountNum;
            String casAcountNum;
            long ifmCurrId;
            long casCurrId;
            BigDecimal ifmAmt;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject settleType = data.getDynamicObject("settletype");
            String transType = data.getString("transtype");
            if (TransTypeEnum.isLinkagePAY((Object)transType)) {
                if (settleType == null || !settleType.getBoolean("is_linkage_payment")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u672a\u542f\u7528\u8054\u52a8\u652f\u4ed8\uff0c\u4e0d\u652f\u6301\u8054\u52a8\u652f\u4ed8\u3002", (String)"PayAcceptanceSaveValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (data.getDynamicObject("agentpayeraccount") == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u8054\u52a8\u652f\u4ed8\uff0c\u7ed3\u7b97\u4e2d\u5fc3\u94f6\u884c\u8d26\u53f7\u5fc5\u586b\u3002", (String)"PayAcceptanceSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (data.getDynamicObject("bankaccount") == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u8054\u52a8\u652f\u4ed8\uff0c\u6210\u5458\u5355\u4f4d\u94f6\u884c\u8d26\u53f7\u5fc5\u586b\u3002", (String)"PayAcceptanceSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            }
            if (!TransTypeEnum.isLinkagePAY((Object)transType) && !TransTypeEnum.isAgentPay((Object)transType)) continue;
            String sourceType = data.getString("sourcebilltype");
            long sourceBillId = data.getLong("sourcebillid");
            if (!"cas_paybill".equals(sourceType)) continue;
            DynamicObject paymentBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"actpayamt,currency,recaccbankname,payeename,payeebanknum", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
            BigDecimal casAmt = paymentBill.getBigDecimal("actpayamt");
            if (casAmt.compareTo(ifmAmt = data.getBigDecimal("actpayamt")) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if ((casCurrId = paymentBill.getLong("currency")) != (ifmCurrId = data.getDynamicObject("currency").getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            String casRecName = paymentBill.getString("recaccbankname");
            String ifmRecName = data.getString("recaccbankname");
            String casPeeName = paymentBill.getString("payeename");
            String ifmPeeName = data.getString("payeename");
            boolean isBei = PaymentChanEnum.BEI.getValue().equals(data.getString("paymentchannel"));
            if (isBei && !casPeeName.equals(ifmPeeName)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u6237\u540d\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u6536\u6b3e\u4eba\u6237\u540d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (!isBei && !casRecName.equals(ifmRecName)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u6536\u6b3e\u4eba\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if ((casAcountNum = paymentBill.getString("payeebanknum")).equals(ifmAcountNum = data.getString("payeebanknum"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u6536\u6b3e\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

