/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.payacceptancebill;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.opservice.helper.TransBillBusHelper;
import kd.tmc.ifm.enums.PayAcceptBizStatusEnum;
import kd.tmc.ifm.enums.PaymentChanEnum;
import kd.tmc.ifm.enums.TransTypeEnum;
import org.apache.commons.lang.StringUtils;

public class PayAcceptanceSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("agentfinorgcat");
        selector.add("agentpayeraccount");
        selector.add("agentpayeraccname");
        selector.add("agentfinorg");
        selector.add("billstatus");
        selector.add("bizstatus");
        selector.add("settletype");
        selector.add("paymentchannel");
        selector.add("usage");
        selector.add("bankaccount");
        selector.add("actpayamt");
        selector.add("currency");
        selector.add("recaccbankname");
        selector.add("payeename");
        selector.add("payeebanknum");
        selector.add("sourcebilltype");
        selector.add("sourcebillid");
        selector.add("singlestream");
        selector.add("iscrosspay");
        selector.add("feeactbank");
        selector.add("feecurrency");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String res;
            String transType;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String bizStatus = dataEntity.getString("bizstatus");
            if (bizStatus.equals(PayAcceptBizStatusEnum.REFUSED.getValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u9000\u5355\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PayAcceptanceSubmitValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (TransTypeEnum.isAgentPay((Object)(transType = dataEntity.getString("transtype")))) {
                if (this.checkAgentAccount(dataEntity)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u5185\u90e8\u4ee3\u4ed8\u65f6\uff0c\u4ee3\u7406\u652f\u4ed8\u4fe1\u606f\u5fc5\u586b\u3002", (String)"PayAcceptanceSubmitValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            } else if (TransTypeEnum.isLinkagePAY((Object)transType)) {
                DynamicObject bankAccount;
                if (this.checkAgentAccount(dataEntity)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u8054\u52a8\u652f\u4ed8\u65f6\uff0c\u7ed3\u7b97\u4e2d\u5fc3\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u5fc5\u586b\u3002", (String)"PayAcceptanceSubmitValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((DynamicObject)(bankAccount = dataEntity.getDynamicObject("bankaccount")))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u8054\u52a8\u652f\u4ed8\u65f6\uff0c\u6210\u5458\u5355\u4f4d\u94f6\u884c\u8d26\u53f7\u5fc5\u586b\u3002", (String)"PayAcceptanceSubmitValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
            }
            if (TransTypeEnum.isAgentPay((Object)transType) || TransTypeEnum.isLinkagePAY((Object)transType)) {
                DynamicObject agentPayerAccount = dataEntity.getDynamicObject("agentpayeraccount");
                DynamicObject settleType = dataEntity.getDynamicObject("settletype");
                if (EmptyUtil.isEmpty((DynamicObject)settleType)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e3a\u5185\u90e8\u4ee3\u4ed8\u6216\u8054\u52a8\u652f\u4ed8\u65f6\uff0c\u7ed3\u7b97\u65b9\u5f0f\u4fe1\u606f\u5fc5\u586b\u3002", (String)"PayAcceptanceSubmitValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
                }
                if (agentPayerAccount != null) {
                    String ifmAcountNum;
                    String casAcountNum;
                    long ifmCurrId;
                    long casCurrId;
                    BigDecimal ifmAmt;
                    DynamicObjectCollection settlementTypes = agentPayerAccount.getDynamicObjectCollection("settlementtype");
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)settlementTypes)) {
                        Set settleTypeIds = settlementTypes.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                        Map settleTypeMap = TmcDataServiceHelper.loadFromCache((String)"bd_settlementtype", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", settleTypeIds)});
                        Set settleTypeNames = settleTypeMap.values().stream().map(o -> o.getString("name")).collect(Collectors.toSet());
                        if (settleType != null && !settleTypeIds.contains(settleType.getPkValue())) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u548c\u4ee3\u7406\u8d26\u53f7\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f[%s]\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PayAcceptanceSubmitValidator_5", (String)"tmc-ifm-business", (Object[])new Object[]{StringUtils.join(settleTypeNames, (String)",")}));
                        }
                    }
                    if (PaymentChanEnum.BEI.getValue().equals(dataEntity.getString("paymentchannel"))) {
                        if (agentPayerAccount.getBoolean("issetbankinterface") && EmptyUtil.isEmpty((String)dataEntity.getString("usage"))) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ee3\u7406\u8d26\u53f7\u5f00\u901a\u94f6\u4f01\u4e14\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8f6c\u8d26\u9644\u8a00\u5fc5\u586b\u3002", (String)"PayAcceptanceSubmitValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
                        }
                        if (!agentPayerAccount.getBoolean("issetbankinterface")) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ee3\u7406\u8d26\u53f7\u672a\u5f00\u901a\u94f6\u4f01\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u94f6\u4f01\u4e92\u8054\u3002", (String)"PayAcceptanceSubmitValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
                        }
                    }
                    String sourceType = dataEntity.getString("sourcebilltype");
                    long sourceBillId = dataEntity.getLong("sourcebillid");
                    if (!"cas_paybill".equals(sourceType)) continue;
                    DynamicObject paymentBill = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"actpayamt,currency,recaccbankname,payeename,payeebanknum", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
                    BigDecimal casAmt = paymentBill.getBigDecimal("actpayamt");
                    if (casAmt.compareTo(ifmAmt = dataEntity.getBigDecimal("actpayamt")) != 0) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                    if ((casCurrId = paymentBill.getLong("currency")) != (ifmCurrId = dataEntity.getDynamicObject("currency").getLong("id"))) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5e01\u79cd\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                    String casRecName = paymentBill.getString("recaccbankname");
                    String ifmRecName = dataEntity.getString("recaccbankname");
                    String casPeeName = paymentBill.getString("payeename");
                    String ifmPeeName = dataEntity.getString("payeename");
                    boolean isBei = PaymentChanEnum.BEI.getValue().equals(dataEntity.getString("paymentchannel"));
                    if (isBei && !casPeeName.equals(ifmPeeName)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u6237\u540d\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u6536\u6b3e\u4eba\u6237\u540d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_5", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                    if (!isBei && !casRecName.equals(ifmRecName)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u6536\u6b3e\u4eba\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_6", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                    if (!(casAcountNum = paymentBill.getString("payeebanknum")).equals(ifmAcountNum = dataEntity.getString("payeebanknum"))) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u548c\u4ed8\u6b3e\u5904\u7406\u5355\u7684\u6536\u6b3e\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PayAcceptanceSaveValidator_7", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    }
                }
            }
            if (!EmptyUtil.isNoEmpty((String)(res = TransBillBusHelper.checkFeeInfo(extendedDataEntity)))) continue;
            this.addErrorMessage(extendedDataEntity, res);
        }
    }

    private boolean checkAgentAccount(DynamicObject dataEntity) {
        DynamicObject agentFinOrg = dataEntity.getDynamicObject("agentfinorg");
        DynamicObject agentPayerAccount = dataEntity.getDynamicObject("agentpayeraccount");
        return EmptyUtil.isAnyoneEmpty((Object[])new Object[]{agentFinOrg, agentPayerAccount});
    }
}

