/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.preint;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.CurrentBizTypeEnum;
import kd.tmc.ifm.enums.PreIntWayEnum;
import kd.tmc.ifm.helper.SettleIntWriteOffHelper;

public class CurrentPreIntBillUnRedWriteOffValidate
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("settlecenter");
        selector.add("biztype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            if (!this.validateRedWriteOffParam(extendedDataEntity)) continue;
            this.validateBizType(extendedDataEntity);
        }
    }

    private boolean validateRedWriteOffParam(ExtendedDataEntity extendedDataEntity) {
        DynamicObject currentInt = extendedDataEntity.getDataEntity();
        String bizType = currentInt.getString("biztype");
        DynamicObject settleCenter = currentInt.getDynamicObject("settlecenter");
        String preIntWay = SettleIntWriteOffHelper.getPreIntWay((DynamicObject)settleCenter);
        if (EmptyUtil.isEmpty((String)preIntWay)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u7ed3\u7b97\u4e2d\u5fc3\u9884\u63d0\u65b9\u6cd5", (String)"CurrentPreIntBillRedWriteOffValidate_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        if (CurrentBizTypeEnum.isPreInt((String)bizType) && !StringUtils.equals((CharSequence)PreIntWayEnum.CEBTF.getValue(), (CharSequence)preIntWay)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ed3\u7b97\u4e2d\u5fc3\u9884\u63d0\u65b9\u6cd5\u4e3a\uff1a\u201c\u5dee\u989d\u8865\u63d0\u6cd5\u201d", (String)"CurrentPreIntBillRedWriteOffValidate_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateBizType(ExtendedDataEntity extendedDataEntity) {
        DynamicObject preIntBill = extendedDataEntity.getDataEntity();
        String billStatus = preIntBill.getString("billstatus");
        String bizType = preIntBill.getString("biztype");
        if (!CurrentBizTypeEnum.isReversePreInt((String)bizType) || !StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u522b\u4e3a\u51b2\u9500\u9884\u63d0\u7ed3\u606f\u624d\u5141\u8bb8\u53cd\u7ea2\u5b57\u51b2\u9500", (String)"CurrentPreIntBillUnRedWriteOffValidate_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

