/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.settcentersetting;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class InnerAccountInitBackValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List dts = Stream.of(dataEntity).map(v -> v.getDataEntity()).collect(Collectors.toList());
        List innerAccountIdList = dts.stream().map(e -> e.get("inneraccount.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("inneracct.id", "in", innerAccountIdList);
        DynamicObjectCollection accountIdInfo = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,inneracct.id,bank", (QFilter[])new QFilter[]{qFilter});
        Map<Long, Long> innerAccountIdAndIdMap = accountIdInfo.stream().collect(Collectors.toMap(e -> e.getLong("inneracct.id"), e -> e.getLong("id")));
        List bankIds = accountIdInfo.stream().map(d -> d.getLong("bank")).collect(Collectors.toList());
        Map acceptDateMap = IfmSettleCenterHelper.getAcceptDateMap(bankIds);
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject initDO = entity.getDataEntity();
            long innerAccountPkId = initDO.getLong("inneraccount.id");
            Long accountPkId = innerAccountIdAndIdMap.get(innerAccountPkId);
            Object amountDate = initDO.get("amountdate");
            String bankAccountNumber = initDO.getString("inneraccount.number");
            DynamicObject currency = initDO.getDynamicObject("currency");
            boolean isInit = initDO.getBoolean("isinit");
            if (!isInit) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"[%s]\uff1a\u8be5\u6761\u6570\u636e\u672a\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u53cd\u521d\u59cb\u5316\u3002", (String)"InnerAccountInitBackValidator_0", (String)"tmc-ifm-business", (Object[])new Object[]{bankAccountNumber}));
                continue;
            }
            if (accountPkId == null) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"[%s]\uff1a\u6ca1\u6709\u8be5\u6761\u6570\u636e\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u3002", (String)"InnerAccountInitBackValidator_2", (String)"tmc-ifm-business", (Object[])new Object[]{bankAccountNumber}));
                continue;
            }
            Long bankId = (Long)initDO.getDynamicObject("inneraccount.finorg").getPkValue();
            Date acceptDate = (Date)acceptDateMap.get(bankId);
            if (!acceptDate.after((Date)amountDate)) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"[%1$s]\uff1a\u4f59\u989d\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u53d7\u7406\u65e5\u671f[%2$s]\u3002", (String)"InnerAccountInitBackValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]), bankAccountNumber, DateUtils.formatString((Date)acceptDate, (String)"yyyy-MM-dd")));
        }
    }
}

