/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.settcentersetting;

import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.ifm.enums.TransDateTypeEnum;

public class TransDateSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Date opDate;
            DynamicObject info = dataEntity.getDataEntity();
            String transDateType = (String)info.get("transdatetype");
            Date fixationDate = info.getDate("fixationdate");
            if (!TransDateTypeEnum.FIXATION_DAY.getValue().equals(transDateType)) continue;
            if (fixationDate.after(new Date())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fa\u5b9a\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"TransDateSaveValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            String[] temp = new String[]{"ifm_transhandlebill", "ifm_rectransbill"};
            QFilter qFilter = new QFilter("sourcebilltype", "in", (Object)temp);
            DataSet bds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_transdetail", (String)"bizdate", (QFilter[])new QFilter[]{qFilter}, null).groupBy().max("bizdate").finish();
            if (bds.hasNext()) {
                Date transMaxDate = bds.next().getDate("bizdate");
                String year = String.format("%tY", transMaxDate);
                String month = String.format("%tm", transMaxDate);
                String day = String.format("%td", transMaxDate);
                if (!fixationDate.before(transMaxDate)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5df2\u7ecf\u5b8c\u6210\u7684\u4ea4\u6613\u65e5\u671f%1$s\u5e74%2$s\u6708%3$s\u65e5\u3002", (String)"TransDateSaveValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]), year, month, day));
                continue;
            }
            DataSet openDate = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_inneracct", (String)"open_date", (QFilter[])new QFilter[]{new QFilter("acctstatus", "in", (Object)new String[]{"normal", "closing", "changing"})}, null).groupBy().max("open_date").finish();
            if (!openDate.hasNext() || !fixationDate.before(opDate = openDate.next().getDate("open_date"))) continue;
            String year = String.format("%tY", opDate);
            String month = String.format("%tm", opDate);
            String day = String.format("%td", opDate);
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5df2\u7ecf\u5b8c\u6210\u7684\u5f00\u6237\u65e5\u671f%1$s\u5e74%2$s\u6708%3$s\u65e5\u3002", (String)"TransDateSaveValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]), year, month, day));
        }
    }
}

