/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transdetail;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TranshandlePushEleValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("ismatchereceipt");
        sel.add("receiptNo");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        Set<Object> TransPushEles = new HashSet();
        if (dataEntitys != null && dataEntitys.length > 0) {
            Set transIds = Arrays.stream(dataEntitys).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection eleColl = QueryServiceHelper.query((String)"ifm_elecreceipt", (String)"transdetailid", (QFilter[])new QFilter[]{new QFilter("transdetailid", "in", transIds)});
            TransPushEles = eleColl.stream().map(o -> o.getLong("transdetailid")).collect(Collectors.toSet());
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                DynamicObject data = dataEntity.getDataEntity();
                if (data.getBoolean("ismatchereceipt")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u5df2\u751f\u6210\u5185\u90e8\u7535\u5b50\u56de\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (String)"TranshandlePushEleValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    continue;
                }
                String receiptNo = data.getString("receiptNo");
                if (receiptNo != null && EmptyUtil.isNoEmpty((String)receiptNo.trim())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u5173\u8054\u6807\u8bb0\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u5185\u90e8\u7535\u5b50\u56de\u5355", (String)"TranshandlePushEleValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
                    continue;
                }
                if (!TransPushEles.contains(data.getLong("id"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u660e\u7ec6\u5df2\u751f\u6210\u5185\u90e8\u7535\u5b50\u56de\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (String)"TranshandlePushEleValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }
}

