/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.ifm.helper.JournalBookHelper;
import kd.tmc.ifm.helper.TransValidatorHelper;

public abstract class AbstractTransBillCancelPayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("iscommitbe");
        selector.add("billstatus");
        selector.add("paidstatus");
        selector.add("sourcebilltype");
        selector.add("sourcebillid");
        selector.add("sourcebillentryid");
        selector.add("paydate");
        selector.add("bankcheckflag");
        return selector;
    }

    protected Map<Long, ExtendedDataEntity> toIdEntityMap(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        HashMap<Long, ExtendedDataEntity> idEntityMap = new HashMap<Long, ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            idEntityMap.put(dataEntity.getDataEntity().getLong("id"), dataEntity);
        }
        return idEntityMap;
    }

    protected void checkJournal(Map<Long, ExtendedDataEntity> idEntityMap, String entityname, List<Long> billIdsForCheckJournal) {
        if (!billIdsForCheckJournal.isEmpty()) {
            Map invalidMap = JournalBookHelper.validateBeforeCancel((String)entityname, billIdsForCheckJournal);
            for (Map.Entry entry : invalidMap.entrySet()) {
                ExtendedDataEntity exd = idEntityMap.get(entry.getKey());
                if (exd == null) continue;
                this.addErrorMessage(exd, (String)entry.getValue());
            }
        }
    }

    protected void checkVoucher(Map<Long, ExtendedDataEntity> idEntityMap, String entityname, List<Long> billIds) {
        if (!billIds.isEmpty()) {
            Set hasVoucherIds = TransValidatorHelper.hasVoucherList((String)entityname, billIds);
            for (Long billId : hasVoucherIds) {
                this.addErrorMessage(idEntityMap.get(billId), ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u53d6\u6d88\u4ed8\u6b3e", (String)"AbstractTransBillCancelPayValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }

    protected void checkTransdetail(Map<Long, ExtendedDataEntity> idEntityMap, String entityname, List<Long> billIds, Set<Long> bankmentIds) {
        if (!billIds.isEmpty()) {
            Set refIds = TransValidatorHelper.checkTransDetailRef((String)entityname, billIds, bankmentIds);
            for (Long billId : refIds) {
                this.addErrorMessage(idEntityMap.get(billId), ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5df2\u4e0b\u8f7d\u5bf9\u8d26\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e", (String)"AbstractTransBillCancelPayValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
        }
    }

    protected void checkSettleCenterAcceptDate(Map<Long, ExtendedDataEntity> idEntityMap, String entityname, List<Long> billIds) {
        Set errorBillIds = TransValidatorHelper.checkSetterCenterAcceptdate((String)entityname, billIds);
        for (Long billId : errorBillIds) {
            this.addErrorMessage(idEntityMap.get(billId), ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u65e9\u4e8e\u7ed3\u7b97\u4e2d\u5fc3\u53d7\u7406\u65e5\u671f\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c", (String)"AbstractTransBillCancelPayValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

