/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Push2TransHandleBillValidator
extends AbstractTmcBizOppValidator {
    public Set<String> preparePropertys() {
        Set sel = super.preparePropertys();
        sel.add("isrelcash");
        sel.add("isinit");
        sel.add("eassrcid");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            QFilter filter;
            DynamicObjectCollection paybills;
            Object[] targetBillIds;
            DynamicObject bill = dataEntity.getDataEntity();
            if (!bill.getBoolean("isrelcash")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u4ea7\u751f\u73b0\u91d1\u6d41\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u3002", (String)"Push2TransHandleBillValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (bill.getBoolean("isinit")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5355\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u3002", (String)"Push2TransHandleBillValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)bill.getString("eassrcid"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"EAS\u5347\u7ea7\u8fc7\u6765\u7684\u6570\u636e\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u3002", (String)"Push2TransHandleBillValidator_4", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object[])(targetBillIds = TmcBotpHelper.getTargetBillIds((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"ifm_transhandlebill"))) || (paybills = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"billno", (QFilter[])(filter = new QFilter("id", "in", (Object)targetBillIds)).toArray())).isEmpty()) continue;
            String billnos = paybills.stream().map(p -> p.getString("billno")).collect(Collectors.joining(","));
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u636e:%s\u3002", (String)"Push2TransHandleBillValidator_5", (String)"tmc-ifm-business", (Object[])new Object[]{billnos}));
        }
    }
}

