/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.ifm.enums.TransTypeEnum;

public class TransHandleBillAuditValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set agentPayerAccountSet = Arrays.stream(this.dataEntities).filter(d -> d.getDataEntity().getDynamicObject("agentpayeraccount") != null).map(d -> d.getDataEntity().getDynamicObject("agentpayeraccount").getPkValue()).collect(Collectors.toSet());
        Map<Object, Object> accountStatusMap = new HashMap(this.dataEntities.length);
        if (!agentPayerAccountSet.isEmpty()) {
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter("id", "in", agentPayerAccountSet).toArray());
            accountStatusMap = accounts.stream().collect(Collectors.toMap(e -> e.get("id"), e -> e.getString("acctstatus")));
        }
        TmcErrorCode paymentErrorCode = new TmcErrorCode();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String transType = (String)info.get("transtype");
            DynamicObject agentPayerAccount = info.getDynamicObject("agentpayeraccount");
            if (TransTypeEnum.INNER_AGENT_PAY.getValue().equals(transType) && agentPayerAccount == null) {
                this.addMessage(dataEntity, String.format(paymentErrorCode.BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237", (String)"TransHandleBillAuditValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0])));
                continue;
            }
            if (agentPayerAccount == null || !BankAcctStatusEnum.CLOSED.getValue().equals(accountStatusMap.get(agentPayerAccount.getPkValue()))) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d26\u6237%1$s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"TransHandleBillAuditValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]), agentPayerAccount.getString("number")));
        }
    }
}

