/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.business.resources.IfmBusResourceEnum;
import kd.tmc.ifm.enums.BillStatusEnum;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;
import kd.tmc.ifm.mservice.transdetail.TransDetailService;

public class TransHandleBillConfirmPayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("transtype");
        selector.add("iscommitbe");
        selector.add("billstatus");
        selector.add("paidstatus");
        selector.add("sourcebilltype");
        selector.add("e_sourcebillid");
        selector.add("sourcebillentryid");
        selector.add("paymentidentify");
        selector.add("agentpayeraccount");
        selector.add("currency");
        selector.add("actpayamt");
        selector.add("settletype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set agentPayerAccountSet = Arrays.stream(this.dataEntities).filter(d -> d.getDataEntity().getDynamicObject("agentpayeraccount") != null).map(d -> d.getDataEntity().getDynamicObject("agentpayeraccount").getPkValue()).collect(Collectors.toSet());
        Map<Object, Object> accountStatusMap = new HashMap(this.dataEntities.length);
        if (!agentPayerAccountSet.isEmpty()) {
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,acctstatus", (QFilter[])new QFilter("id", "in", agentPayerAccountSet).toArray());
            accountStatusMap = accounts.stream().collect(Collectors.toMap(e -> e.get("id"), e -> e.getString("acctstatus")));
        }
        List<Long> transIds = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map<Long, String> transDetailMap = this.getTransDetailMap(transIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject agentPayerAccount;
            DynamicObject info = dataEntity.getDataEntity();
            String billStatus = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"TransHandleBillConfirmPayValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            DynamicObject dt = QueryServiceHelper.queryOne((String)"ifm_transhandlebill", (String)"paidstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", info.getPkValue())});
            String paidStatus = dt.getString("paidstatus");
            if (!TransBillPaidStatusEnum.WAITING.getValue().equals(paidStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u4ed8\u6b3e\u7684\u5355\u636e\u624d\u80fd\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"TransHandleBillConfirmPayValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if ((agentPayerAccount = info.getDynamicObject("agentpayeraccount")) != null && BankAcctStatusEnum.CLOSED.getValue().equals(accountStatusMap.get(agentPayerAccount.getPkValue()))) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d26\u6237%1$s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"TransHandleBillConfirmPayValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]), agentPayerAccount.getString("number")));
            }
            if (!transDetailMap.containsKey(info.getLong("id"))) continue;
            this.addErrorMessage(dataEntity, IfmBusResourceEnum.TransHandleBillConfirmPayValidator_3.loadKDString(transDetailMap.get(info.getLong("id"))));
        }
    }

    private Map<Long, String> getTransDetailMap(List<Long> transIds) {
        HashMap<Long, String> detailMap = new HashMap<Long, String>();
        DynamicObjectCollection detailColls = TransDetailService.getDetailColls(transIds);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)detailColls)) {
            return detailMap;
        }
        return detailColls.stream().collect(Collectors.toMap(o -> o.getLong("sourcebillid"), o -> o.getString("billno"), (v1, v2) -> v2));
    }
}

