/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.business.validator.transhandlebill;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.TransBillPaidStatusEnum;

public class TransHandleBillRefundValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("paidstatus");
        selector.add("acrefundamt");
        selector.add("acrefundreson");
        selector.add("recbill");
        return selector;
    }

    public void validate(ExtendedDataEntity[] datas) throws KDBizException {
        Set billIDs = Arrays.stream(datas).map(dy -> dy.getDataEntity().getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection strategySets = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"id,paidstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billIDs)});
        HashMap idToStatusMap = new HashMap();
        strategySets.stream().forEach(dy -> idToStatusMap.put(dy.getLong("id"), dy.getString("paidstatus")));
        for (ExtendedDataEntity data : datas) {
            DynamicObject transBill = data.getDataEntity();
            String paidStatus = transBill.getString("paidstatus");
            String refundresonMsg = transBill.getString("acrefundreson");
            if (EmptyUtil.isNoEmpty((String)refundresonMsg) && refundresonMsg.trim().length() > 255) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u9000\u6b3e\u8bf4\u660e\u957f\u5ea6\u8d85\u8fc7256\u3002", (String)"TransHandleBillRefundValidator_1", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((String)paidStatus) || Arrays.asList(TransBillPaidStatusEnum.RETURNTICKET.getValue(), TransBillPaidStatusEnum.DRAWBACK.getValue()).indexOf(paidStatus) < 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u72b6\u6001!", (String)"TransHandleBillRefundValidator_0", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((String)paidStatus) && ((String)idToStatusMap.get(transBill.getLong("id"))).equals(paidStatus)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u9000\u6b3e\u9000\u7968!", (String)"TransHandleBillRefundValidator_3", (String)"tmc-ifm-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isEmpty((DynamicObject)transBill.getDynamicObject("recbill"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u56de\u586b\u6536\u6b3e\u5355!", (String)"TransHandleBillRefundValidator_2", (String)"tmc-ifm-business", (Object[])new Object[0]));
        }
    }
}

