/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class BalanceCompareDataPlugin
extends AbstractTmcListDataPlugin {
    private static final String selectProp = "accountbank.bank.name as bank,accountbank.bank.number as banknumber,company,company.number as companynumber,accountbank,currency,amount,amount- case when lstbalance is null then 0 else lstbalance end as predayamount";
    private static final String preDateProp = "company,accountbank,currency,amount";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        Map paraMap = this.transQueryParam(reportQueryParam);
        List<Object> bankAcctIds = this.getBdBankAcctIds(paraMap);
        QFilter qFilter = new QFilter("accountbank", "in", bankAcctIds);
        DynamicObjectCollection filterCols = (DynamicObjectCollection)paraMap.get("filter_currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterCols)) {
            List currencyIds = filterCols.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilter.and("currency", "in", currencyIds);
        }
        Date currDate = (Date)paraMap.get("filter_date");
        QFilter currFilter = new QFilter("bizdate", "=", (Object)currDate);
        DataSet baseDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_accountbalance", (String)selectProp, (QFilter[])new QFilter[]{qFilter, currFilter}, (String)"");
        DataSet lastMonthDs = this.dealLastMonthOrYearDs(currDate, "month", qFilter, bankAcctIds);
        DataSet lastYearDs = this.dealLastMonthOrYearDs(currDate, "year", qFilter, bankAcctIds);
        DataSet tmpDs = baseDs.leftJoin(lastMonthDs).on("accountbank", "accountbank").select(baseDs.getRowMeta().getFieldNames(), new String[]{"amount as lastmonthamount"}).finish();
        DataSet joinedDs = tmpDs.leftJoin(lastYearDs).on("accountbank", "accountbank").select(tmpDs.getRowMeta().getFieldNames(), new String[]{"amount as lastyearamount"}).finish();
        DataSet resultDs = joinedDs.select("bank,banknumber,company,companynumber,accountbank,currency,amount,predayamount,amount-case when lastmonthamount is null then 0 else lastmonthamount end as premonthamount,amount-case when lastyearamount is null then 0 else lastyearamount end as preyearamount,0 as sumlevel").orderBy(new String[]{"companynumber", "banknumber"});
        resultDs = this.dealResultDataSet(resultDs);
        return resultDs;
    }

    private void setInnerAcctF7Filter(List<QFilter> qFilters, Map<String, Object> paraMap, String field, String filterColumn) {
        DynamicObjectCollection filterCols = (DynamicObjectCollection)paraMap.get(filterColumn);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)filterCols)) {
            List ids = filterCols.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter(field, "in", ids));
        }
    }

    private List<Object> getBdBankAcctIds(Map<String, Object> paraMap) {
        DynamicObjectCollection innerAcctCols = (DynamicObjectCollection)paraMap.get("filter_inneracct");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)innerAcctCols)) {
            return innerAcctCols.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        }
        ArrayList<QFilter> innerAcctFilter = new ArrayList<QFilter>();
        this.setInnerAcctF7Filter(innerAcctFilter, paraMap, "bank", "filter_settlecenter");
        this.setInnerAcctF7Filter(innerAcctFilter, paraMap, "company", "filter_company");
        this.setInnerAcctF7Filter(innerAcctFilter, paraMap, "acctproperty", "filter_acctuseage");
        this.setInnerAcctF7Filter(innerAcctFilter, paraMap, "currency.fbasedataid", "filter_currency");
        boolean isInclude = (Boolean)paraMap.get("filter_includeclose");
        if (!isInclude) {
            innerAcctFilter.add(new QFilter("acctstatus", "!=", (Object)"closed"));
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbanks", (QFilter[])innerAcctFilter.toArray(new QFilter[0]), (String)"", (int)-1);
    }

    private DataSet dealResultDataSet(DataSet resultDs) {
        Iterator iterator = resultDs.copy().iterator();
        HashSet<Long> currencySet = new HashSet<Long>(1);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            currencySet.add(row.getLong("currency"));
        }
        if (currencySet.size() == 1) {
            List<String> sumFields = Arrays.asList("amount", "predayamount", "premonthamount", "preyearamount");
            DataSet sumAllDs = this.addAllTotalDataSet(resultDs, sumFields, Collections.singletonList("currency"), "bank");
            resultDs = resultDs.union(sumAllDs);
        }
        return resultDs;
    }

    private DataSet dealLastMonthOrYearDs(Date currDate, String type, QFilter qFilter, List<Object> bankAcctIds) {
        Date lastMonthDate = "month".equals(type) ? DateUtils.getLastMonth((Date)currDate, (int)1) : DateUtils.getLastYear((Date)currDate, (int)1);
        QFilter lastMonthFilter = new QFilter("bizdate", "=", (Object)lastMonthDate);
        DataSet lastMonthDsEq = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_accountbalance", (String)preDateProp, (QFilter[])new QFilter[]{qFilter, lastMonthFilter}, (String)"");
        Iterator it = lastMonthDsEq.copy().iterator();
        HashSet noInitBalIds = new HashSet();
        HashSet<Long> hasInitBalIds = new HashSet<Long>();
        while (it.hasNext()) {
            Row balRow = (Row)it.next();
            Long acctId = balRow.getLong("accountbank");
            hasInitBalIds.add(acctId);
        }
        bankAcctIds.stream().forEach(a -> {
            if (!hasInitBalIds.contains(a)) {
                noInitBalIds.add(a);
            }
        });
        QFilter preBalFilter = new QFilter("accountbank", "in", noInitBalIds);
        preBalFilter.and(new QFilter("bizdate", "<=", (Object)lastMonthDate));
        DataSet preBizDateDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_accountbalance", (String)"accountbank, bizdate", (QFilter[])preBalFilter.toArray(), null);
        preBizDateDS = preBizDateDS.groupBy(new String[]{"accountbank"}).max("bizdate").finish();
        Iterator preIter = preBizDateDS.iterator();
        QFilter preQFilter = null;
        while (preIter.hasNext()) {
            Row balRow = (Row)preIter.next();
            QFilter qf = new QFilter("accountbank ", "=", (Object)balRow.getLong("accountbank"));
            qf.and("bizdate", "=", (Object)balRow.getDate("bizdate"));
            if (preQFilter == null) {
                preQFilter = qf;
                continue;
            }
            preQFilter.or(qf);
        }
        if (preQFilter == null) {
            return lastMonthDsEq;
        }
        DataSet lastMonthDsLess = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_accountbalance", (String)preDateProp, (QFilter[])new QFilter[]{preQFilter}, (String)"");
        if (lastMonthDsLess == null) {
            return lastMonthDsEq;
        }
        return lastMonthDsEq.union(lastMonthDsLess);
    }
}

