/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.ifm.helper.InterestCalcHelper;
import kd.tmc.ifm.report.helper.ReportHelper;

public class DepositInterestCalcDataPlugin
extends AbstractTmcListDataPlugin {
    private static final String QUERY_FEILD = "id as intobjectid,intobject.bank as settlecenterid, intobject.bank.name as settlecentername,intobject as bankacctid,intobject.company as companyid,intobject.company.name as companyname, intobject.name as intobject, intobject.defaultcurrency as currency, intobject.number as accountnum, lastintdate, createtime";

    public DataSet query(ReportQueryParam queryParam, Object info) throws Throwable {
        Map customParam = queryParam.getCustomParam();
        DataSet resultDS = QueryServiceHelper.queryDataSet((String)"DepositInterestCalcDataPluginQuery", (String)"ifm_intobject", (String)QUERY_FEILD, (QFilter[])this.getIntObjectFilter(customParam).toArray(), (String)"createtime");
        resultDS = this.calculateInterest(resultDS, customParam);
        boolean showZero = (Boolean)customParam.get("filter_showzero");
        if (!showZero) {
            resultDS = resultDS.filter("origccy_interestamt != 0");
        }
        resultDS = this.doExchange(resultDS, customParam);
        String unit = (String)customParam.get("filter_unit");
        List<String> changeFields = Arrays.asList("accumulation", "overdraft", "origccy_interestamt", "rptccy_interestamt");
        resultDS = ReportHelper.changeUnit(resultDS, unit, changeFields);
        resultDS = this.addCalAllDadaSet(resultDS, customParam);
        return resultDS;
    }

    private QFilter getIntObjectFilter(Map<String, Object> customParam) {
        QFilter filter = new QFilter("biztype", "=", (Object)"Internal");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        List intObjectIds = (List)customParam.get("filter_intobject");
        if (EmptyUtil.isNoEmpty((Object)intObjectIds)) {
            filter.and(new QFilter("id", "in", (Object)intObjectIds));
        } else {
            List companyIds;
            List currencyIds;
            Object settleCenterId = customParam.get("filter_settlecenter");
            if (EmptyUtil.isNoEmpty((Object)settleCenterId)) {
                filter.and(new QFilter("intobject.bank", "=", settleCenterId));
            }
            if (EmptyUtil.isNoEmpty((Object)(currencyIds = (List)customParam.get("filter_currency")))) {
                filter.and(new QFilter("intobject.defaultcurrency", "in", (Object)currencyIds));
            }
            if (EmptyUtil.isNoEmpty((Object)(companyIds = (List)customParam.get("filter_company")))) {
                filter.and(new QFilter("intobject.company", "in", (Object)companyIds));
            }
        }
        return filter;
    }

    private DataSet calculateInterest(DataSet dataSet, Map<String, Object> customParam) {
        ArrayList<Field> field = new ArrayList<Field>(8);
        field.add(new Field("id", (DataType)DataType.LongType));
        field.add(new Field("interestdatestart", (DataType)DataType.DateType));
        field.add(new Field("interestdateend", (DataType)DataType.DateType));
        field.add(new Field("interestdays", (DataType)DataType.IntegerType));
        field.add(new Field("accumulation", (DataType)DataType.BigDecimalType));
        field.add(new Field("overdraft", (DataType)DataType.BigDecimalType));
        field.add(new Field("origccy_interestamt", (DataType)DataType.BigDecimalType));
        Date startDate = (Date)customParam.get("filter_interestdatestart");
        Date endDate = (Date)customParam.get("filter_interestdateend");
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        DataSetBuilder dataSetbuilder = Algo.create((String)"buildCalcDataSet").createDataSetBuilder(rowMeta);
        ArrayList<Object> bankAcctIds = new ArrayList<Object>(16);
        ArrayList<Object> intObjectIds = new ArrayList<Object>(16);
        ArrayList<Object> currencyIds = new ArrayList<Object>(16);
        for (Row row : dataSet.copy()) {
            bankAcctIds.add(row.get("bankacctid"));
            intObjectIds.add(row.get("intobjectid"));
            currencyIds.add(row.get("currency"));
        }
        Map bankAcctMap = TmcDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("id", "in", bankAcctIds)});
        Map intObjectMap = TmcDataServiceHelper.loadFromCache((String)"ifm_intobject", (QFilter[])new QFilter[]{new QFilter("id", "in", intObjectIds)});
        Map currencyMap = TmcDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        for (Row row : dataSet.copy()) {
            Object rowId = row.get("intobjectid");
            Date lastIntDate = EmptyUtil.isEmpty((Object)startDate) ? DateUtils.getNextDay((Date)row.getDate("lastintdate"), (int)1) : startDate;
            int interestDays = DateUtils.getDiffDays((Date)lastIntDate, (Date)endDate);
            DynamicObject bankAcct = (DynamicObject)bankAcctMap.get(row.get("bankacctid"));
            DynamicObject currency = (DynamicObject)currencyMap.get(row.get("currency"));
            DynamicObject intObject = (DynamicObject)intObjectMap.get(row.get("intobjectid"));
            BigDecimal interestAmt = BigDecimal.ZERO;
            BigDecimal accumuLation = BigDecimal.ZERO;
            BigDecimal overDraft = BigDecimal.ZERO;
            IntBillInfo intBill = InterestCalcHelper.callInt((DynamicObject)bankAcct, (DynamicObject)currency, (Date)lastIntDate, (Date)DateUtils.getNextDay((Date)endDate, (int)1), (boolean)intObject.getBoolean("iscaloverint"));
            if (EmptyUtil.isNoEmpty((Object)intBill)) {
                accumuLation = intBill.getDetails().stream().filter(v -> v.getIntType() == InterTypeEnum.normal).map(IntBillDetailInfo::getPrinciple).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                overDraft = intBill.getDetails().stream().filter(v -> v.getIntType() == InterTypeEnum.overdue).map(IntBillDetailInfo::getPrinciple).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                interestAmt = intBill.getDetails().stream().map(v -> v.getIntType() == InterTypeEnum.normal ? v.getAmount() : new BigDecimal(-1).multiply(v.getAmount())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            dataSetbuilder.append(new Object[]{rowId, lastIntDate, endDate, interestDays, accumuLation, overDraft, interestAmt});
        }
        DataSet build = dataSetbuilder.build();
        return dataSet.leftJoin(build).on("intobjectid", "id").select(new String[]{"intobjectid", "settlecenterid", "settlecentername", "companyname", "intobject", "currency", "accountnum", "interestdatestart", "interestdateend", "interestdays", "bankacctid", "companyid", "accumulation", "overDraft", "origccy_interestamt"}).finish();
    }

    private DataSet doExchange(DataSet resultDataSet, Map<String, Object> customParam) {
        Long rateTableId = (Long)customParam.get("filter_exratetable");
        Long reportCurrencyId = (Long)customParam.get("reportCurrencyId");
        DataSet exchangerateDataSet = this.getExchangeRateDataSet(resultDataSet, reportCurrencyId, rateTableId);
        resultDataSet = resultDataSet.join(exchangerateDataSet).on("currency", "currencyid").select(new String[]{"intobjectid", "settlecenterid", "settlecentername", "companyname", "intobject", "currency", "bankacctid", "companyid", "accountnum", "interestdatestart", "interestdateend", "interestdays", "accumulation", "overDraft", "origccy_interestamt", "origccy_interestamt * exchgRate as rptccy_interestamt", "rpt_currency", "0 as sumlevel"}).finish();
        return resultDataSet;
    }

    private DataSet addCalAllDadaSet(DataSet resultDS, Map<String, Object> customParam) {
        Object reportCurrencyId = customParam.get("reportCurrencyId");
        StringBuilder lvalue = new StringBuilder("CONCAT(companyname,'-").append(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"DepositInterestCalcDataPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0])).append("') as companyname");
        DataSet subTotalDataSet = this.addSubTotalDataSet(resultDS, Arrays.asList("settlecenterid", "companyid", "companyname"), Collections.singletonList("rptccy_interestamt"), "companyname").updateFields(new String[]{"companyname", "rpt_currency"}, new String[]{lvalue.toString(), reportCurrencyId + ""});
        DataSet allTotalaDataSet = this.addAllTotalDataSet(resultDS, Collections.singletonList("rptccy_interestamt"), "settlecentername");
        allTotalaDataSet = allTotalaDataSet.updateField("rpt_currency", reportCurrencyId + "");
        resultDS = resultDS.union(subTotalDataSet).orderBy(new String[]{"settlecenterid", "companyid"});
        return resultDS.union(allTotalaDataSet);
    }

    private DataSet getExchangeRateDataSet(DataSet sourceDataSet, Long targetCurrencyID, Long exchangeRateTableId) {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("currencyid", (DataType)DataType.LongType));
        field.add(new Field("exchgRate", (DataType)DataType.BigDecimalType));
        field.add(new Field("rpt_currency", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        DataSetBuilder datasetBuilder = Algo.create((String)"buildExchangerateDataSet").createDataSetBuilder(rowMeta);
        HashSet<Long> currencySet = new HashSet<Long>();
        Iterator it = sourceDataSet.copy().iterator();
        Date bizDate = DateUtils.getCurrentDate();
        while (it.hasNext()) {
            Object[] obj;
            Row row = (Row)it.next();
            Long sCurrencyId = row.getLong("currency");
            if (!currencySet.add(sCurrencyId)) continue;
            if (targetCurrencyID.equals(sCurrencyId)) {
                obj = new Object[]{sCurrencyId, 1, targetCurrencyID};
            } else {
                BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sCurrencyId, (Long)targetCurrencyID, (Date)bizDate);
                if (exchangeRate == null) {
                    DynamicObject srcCcyDO = TmcDataServiceHelper.loadSingleFromCache((Object)sCurrencyId, (String)"bd_currency");
                    DynamicObject targetCcyDO = TmcDataServiceHelper.loadSingleFromCache((Object)targetCurrencyID, (String)"bd_currency");
                    String accountNum = row.getString("accountnum");
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8d26\u53f7%1$s\u7684\u5e01\u79cd %2$s \u5230\u62a5\u544a\u5e01\u79cd %3$s \u7684\u6c47\u7387", (String)"DepositInterestCalcDataPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0]), accountNum, srcCcyDO.getString("name"), targetCcyDO.getString("name")));
                }
                obj = new Object[]{sCurrencyId, exchangeRate, targetCurrencyID};
            }
            datasetBuilder.append(obj);
        }
        return datasetBuilder.build();
    }
}

