/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;

public class LoanContractBillDataPlugin
extends AbstractTmcListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        QFilter[] filter = this.initFilter(queryParam);
        String sic = "id,billno,finproduct.name,org.name,settlecenter.name,contractno,contractstatus,bizdate,startdate,enddate,interestrate,currency,amount,drawamount,repayamount,payinterestamount";
        return QueryServiceHelper.queryDataSet((String)"loanContractBillRpt", (String)"ifm_loancontractbill", (String)sic, (QFilter[])filter, null);
    }

    private QFilter[] initFilter(ReportQueryParam queryParam) {
        QFilter filter = new QFilter("creditortype", "=", (Object)"settlecenter");
        for (FilterItemInfo item : queryParam.getFilter().getFilterItems()) {
            String property;
            switch (property = item.getPropName()) {
                case "org": {
                    if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)((DynamicObjectCollection)item.getValue()))) break;
                    List idList = ((DynamicObjectCollection)item.getValue()).stream().map(org -> org.getPkValue()).collect(Collectors.toList());
                    filter.and(new QFilter("org.id", "in", idList));
                    break;
                }
                case "settlecenter": {
                    List idList;
                    if (EmptyUtil.isNoEmpty((Object)item.getValue())) {
                        if (item.getValue() instanceof Set) {
                            filter.and(new QFilter("settlecenter.id", "in", item.getValue()));
                            break;
                        }
                        idList = ((DynamicObjectCollection)item.getValue()).stream().map(settlecenter -> settlecenter.getPkValue()).collect(Collectors.toList());
                        filter.and(new QFilter("settlecenter.id", "in", idList));
                        break;
                    }
                    filter.and(QFilter.of((String)" 1= 2", (Object[])new Object[0]));
                    break;
                }
                case "currency": {
                    if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)((DynamicObjectCollection)item.getValue()))) break;
                    List idList = ((DynamicObjectCollection)item.getValue()).stream().map(currency -> currency.getPkValue()).collect(Collectors.toList());
                    filter.and(new QFilter("currency.id", "in", idList));
                    break;
                }
                case "contractbillstatus": {
                    if (!EmptyUtil.isNoEmpty((Object)item.getValue())) break;
                    String[] status = ((String)item.getValue()).split(",");
                    Set sSet = Arrays.asList(status).stream().filter(s -> EmptyUtil.isNoEmpty((String)s)).collect(Collectors.toSet());
                    filter.and(new QFilter("contractstatus", "in", sSet));
                    break;
                }
                case "contractbilldate_startdate": {
                    if (!EmptyUtil.isNoEmpty((Object)item.getValue())) break;
                    filter.and(new QFilter("bizdate", ">=", item.getValue()));
                    break;
                }
                case "contractbilldate_enddate": {
                    if (!EmptyUtil.isNoEmpty((Object)item.getValue())) break;
                    filter.and(new QFilter("bizdate", "<=", item.getValue()));
                }
            }
        }
        return filter.toArray();
    }
}

