/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.ifm.helper.DepositHelper;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RevEstimateReportDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String SELECT_PROP = "id,billno,org,org.name as orgname,product,product.name as productname,finorginfo as settlecenter,finorginfo.name as settlecentername,currency,currency as oricurrency,currency.name as currencyname,intdate,expiredate,interestrate,product.servicecategory as busitype";
    private String statdim;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        this.statdim = queryParam.getFilter().getString("filter_statdim");
        List<QFilter> qFilters = this.buildQueryFilter(queryParam);
        DataSet baseDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_deposit", (String)SELECT_PROP, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
        if (baseDs.isEmpty()) {
            return baseDs;
        }
        DataSet waitCalRevDs = this.filterByRevenueDate(baseDs, queryParam);
        Map<Long, IntBillInfo> intMap = this.buildIntBillInfo(waitCalRevDs);
        DataSet intBillDs = this.buildIntBillDataSet(intMap);
        DataSet joinedDs = waitCalRevDs.leftJoin(intBillDs).on("id", "id").select(waitCalRevDs.getRowMeta().getFieldNames(), new String[]{"startdayamount", "oriestimateint", "revdays"}).finish();
        if (!queryParam.getFilter().getBoolean("filter_showzeroint")) {
            joinedDs = this.filterZeroIntData(joinedDs);
        }
        return joinedDs;
    }

    public String subNameField() {
        return this.statdim + "name";
    }

    public List<String> groupFields() {
        ArrayList<String> list = new ArrayList<String>(8);
        list.add(this.statdim + "name");
        return list;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(8);
        sumFields.add("statestimateint");
        return sumFields;
    }

    public String sumNameField() {
        return this.statdim + "name";
    }

    public List<String> subAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(8);
        sumFields.add("statestimateint");
        return sumFields;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("oriestimateint", "startdayamount");
    }

    protected String getReportField(String field) {
        if ("startdayamount".equals(field)) {
            return super.getReportField(field);
        }
        return field.replace("ori", "stat");
    }

    private DataSet buildIntBillDataSet(Map<Long, IntBillInfo> intBillInfoMap) {
        ArrayList<Field> field = new ArrayList<Field>(8);
        field.add(new Field("id", (DataType)DataType.LongType));
        field.add(new Field("startdayamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("oriestimateint", (DataType)DataType.BigDecimalType));
        field.add(new Field("revdays", (DataType)DataType.IntegerType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"BuildIntDataSet");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, IntBillInfo> entry : intBillInfoMap.entrySet()) {
            IntBillInfo intBillInfo = entry.getValue();
            List details = intBillInfo.getDetails();
            if (EmptyUtil.isEmpty((Collection)details)) continue;
            BigDecimal startdayamount = ((IntBillDetailInfo)details.get(0)).getPrinciple();
            BigDecimal revenueamount = Optional.ofNullable(intBillInfo.getAmount()).orElse(BigDecimal.ZERO);
            Integer reventrydays = details.stream().map(r -> r.getDays()).reduce(0, (a, b) -> a + b);
            Object[] obj = new Object[]{entry.getKey(), startdayamount, revenueamount, reventrydays};
            dsBuilder.append(obj);
        }
        return dsBuilder.build();
    }

    private Map<Long, IntBillInfo> buildIntBillInfo(DataSet dataSet) {
        DynamicObject[] depositBills;
        int count = dataSet.copy().count("id", false);
        HashMap<Long, IntBillInfo> intMap = new HashMap<Long, IntBillInfo>(count);
        HashMap<Long, Pair> idMap = new HashMap<Long, Pair>(count);
        for (Row row : dataSet.copy()) {
            Long depositId = row.getLong("id");
            idMap.put(depositId, Pair.of((Object)row.getDate("revstartdate"), (Object)row.getDate("revenddate")));
        }
        for (DynamicObject deposit : depositBills = TmcDataServiceHelper.load((Object[])idMap.keySet().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ifm_deposit"))) {
            long id = deposit.getLong("id");
            Pair datePair = (Pair)idMap.get(id);
            IntBillInfo intBillInfo = DepositHelper.calcDepositBillIntForReport((DynamicObject)deposit, (Date)((Date)datePair.getLeft()), (Date)((Date)datePair.getRight()));
            intMap.put(id, intBillInfo);
        }
        return intMap;
    }

    private DataSet filterByRevenueDate(DataSet baseDs, ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date startDate = filter.getDate("filter_revstartdate");
        if (EmptyUtil.isEmpty((Object)startDate)) {
            baseDs = baseDs.addField("intdate", "revstartdate");
        } else {
            String startDateStr = DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd");
            baseDs = baseDs.addField("cast('" + startDateStr + "' as Timestamp)", "filter_revstartdate").addField("(case when filter_revstartdate > intdate then filter_revstartdate else intdate end)", "revstartdate");
        }
        String endDateStr = DateUtils.formatString((Date)filter.getDate("filter_revenddate"), (String)"yyyy-MM-dd");
        baseDs = baseDs.addField("cast('" + endDateStr + "' as Timestamp)", "filter_revenddate").addField("(case when expiredate is null then filter_revenddate when filter_revenddate < expiredate then filter_revenddate else expiredate end)", "revenddate");
        return baseDs.filter("revstartdate <= revenddate");
    }

    private List<QFilter> buildQueryFilter(ReportQueryParam queryParam) {
        List busiTypeList;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        this.addTradeChannelFilter(filterList);
        filterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List finOrgTypeIds = DepositHelper.getScFinOrgTypeIds();
        filterList.add(new QFilter("finorginfo.finorgtype", "in", (Object)finOrgTypeIds));
        FilterInfo filter = queryParam.getFilter();
        filterList.add(new QFilter("intdate", "<=", (Object)filter.getDate("filter_revenddate")));
        this.addMultiBaseDataFilter(filterList, filter, "filter_product", "product");
        this.addMultiBaseDataFilter(filterList, filter, "filter_currency", "currency");
        filterList.add(new QFilter("org", "in", this.getOrgFilter(queryParam)));
        List finOrgIdList = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_revestimaterpt", (String)"47150e89000000ac");
        filterList.add(new QFilter("finorginfo", "in", (Object)finOrgIdList));
        String busiType = filter.getString("filter_busitype");
        if (EmptyUtil.isNoEmpty((String)busiType) && EmptyUtil.isNoEmpty(busiTypeList = Arrays.stream(busiType.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList()))) {
            QFilter categoryFilter = new QFilter("product.servicecategory", "in", busiTypeList);
            filterList.add(categoryFilter);
        }
        return filterList;
    }

    private void addTradeChannelFilter(List<QFilter> filterList) {
        QFilter online = new QFilter("tradechannel", "=", (Object)"online");
        QFilter onlineFilter = online.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()));
        QFilter offFilter = new QFilter("tradechannel", "!=", (Object)"online");
        QFilter tradeChannelFilter = onlineFilter.or(offFilter);
        filterList.add(tradeChannelFilter);
    }

    private void addMultiBaseDataFilter(List<QFilter> filterList, FilterInfo filter, String multiProp, String billProp) {
        DynamicObjectCollection multiCols = filter.getDynamicObjectCollection(multiProp);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)multiCols)) {
            List multiIds = multiCols.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            QFilter currencyFilter = new QFilter(billProp, "in", multiIds);
            filterList.add(currencyFilter);
        }
    }

    private List<Long> getOrgFilter(ReportQueryParam queryParam) {
        List orgIds = (List)queryParam.getFilter().getValue("filter_org");
        if (EmptyUtil.isEmpty((Collection)orgIds)) {
            Map paraMap = queryParam.getCustomParam();
            orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)((String)paraMap.get("appid")), (String)((String)paraMap.get("formid")), (String)"47150e89000000ac");
        }
        return orgIds;
    }

    private DataSet filterZeroIntData(DataSet dataSet) {
        return dataSet.filter("oriestimateint is not null and oriestimateint <> 0");
    }
}

