/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.ifm.enums.AcctClassifyEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;

public class StatementDataList
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object o) throws Throwable {
        Map<String, Object> paramMap = this.transQueryParam(param);
        DynamicObject settcenter = (DynamicObject)paramMap.get("filter_settcenter");
        DynamicObject company = (DynamicObject)paramMap.get("filter_company");
        DynamicObject accountBank = (DynamicObject)paramMap.get("filter_accountbank");
        Date bizdate_startdate = (Date)paramMap.get("bizdate_startdate");
        Date bizdate_enddate = (Date)paramMap.get("bizdate_enddate");
        ArrayList<QFilter> balEndQFilterList = new ArrayList<QFilter>();
        if (company != null) {
            balEndQFilterList.add(new QFilter("company.id", "=", company.getPkValue()));
        }
        if (accountBank != null) {
            balEndQFilterList.add(new QFilter("accountbank.id", "=", accountBank.getPkValue()));
        }
        if (bizdate_enddate != null) {
            balEndQFilterList.add(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)bizdate_enddate, (boolean)Boolean.FALSE)));
        }
        DataSet innerAccDataSet = this.queryAccts(paramMap);
        ArrayList<Long> innerAcctIds = new ArrayList<Long>(10);
        for (Row idRow : innerAccDataSet.copy()) {
            innerAcctIds.add(idRow.getLong("id"));
        }
        if (innerAcctIds.size() == 0) {
            RowMeta emptyRowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
            return Algo.create((String)"EmptyDataSet").createDataSetBuilder(emptyRowMeta).build();
        }
        DataSet beginBalDS = this.queryBeginBalance(paramMap, innerAcctIds);
        beginBalDS = innerAccDataSet.join(beginBalDS, JoinType.LEFT).on("id", "accountbank.id").on("currencyid", "currency.id").select(new String[]{"company.id", "bank.id", "id as accountbank.id", "bankaccountnumber", "currencyid as currency.id", "currency.name", "amount as lstbalance"}).finish();
        DataSet transDetailDS = this.queryTranDetails(paramMap, innerAcctIds);
        DataSet resultDataSet = beginBalDS.join(transDetailDS, JoinType.LEFT).on("company.id", "company.id").on("accountbank.id", "accountbank.id").on("currency.id", "currency.id").select(new String[]{"bank.id settcenter", "company.id org", "accountbank.id inneraccount", "currency.id currency", "lstbalance amountstart", "creditamount currincome", "debitamount currpay"}).finish();
        resultDataSet = resultDataSet.updateField("currincome", "case when currincome is not null then currincome else 0 end as currincome").updateField("currpay", "case when currpay is not null then currpay else 0 end as currpay").addField("amountstart+currincome-currpay", "amountend");
        if (bizdate_startdate != null && bizdate_enddate != null) {
            resultDataSet = resultDataSet.addField("to_date('" + DateUtils.formatString((Date)bizdate_startdate, (String)"yyyy-MM-dd") + "', 'yyyy-MM-dd')", "datestart");
            resultDataSet = resultDataSet.addField("to_date('" + DateUtils.formatString((Date)bizdate_enddate, (String)"yyyy-MM-dd") + "', 'yyyy-MM-dd')", "dateend");
        }
        return resultDataSet;
    }

    private DataSet queryAccts(Map<String, Object> paramMap) {
        DynamicObject settcenter = (DynamicObject)paramMap.get("filter_settcenter");
        DynamicObject company = (DynamicObject)paramMap.get("filter_company");
        DynamicObject accountBank = (DynamicObject)paramMap.get("filter_accountbank");
        QFilter innerAccQFilter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
        innerAccQFilter.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
        if (settcenter != null) {
            innerAccQFilter.and(new QFilter("bank.id", "=", settcenter.getPkValue()));
        }
        if (company != null) {
            innerAccQFilter.and(new QFilter("company.id", "=", company.getPkValue()));
        }
        if (accountBank != null) {
            innerAccQFilter.and(new QFilter("id", "=", accountBank.getPkValue()));
        }
        String appId = TmcAppEnum.IFM.getValue();
        List orgIdList = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_statementrpt", (String)"47150e89000000ac");
        innerAccQFilter.and(new QFilter("bank.id", "in", (Object)orgIdList));
        String selectInnerAccFields = "id,company.id,bank.id,bankaccountnumber,opendate, currency.fbasedataid.id as currencyid";
        DataSet innerAccDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountbanks", (String)selectInnerAccFields, (QFilter[])innerAccQFilter.toArray(), null);
        return innerAccDataSet;
    }

    private DataSet queryTranDetails(Map<String, Object> paramMap, List<Long> innerAcctIds) {
        DynamicObject company = (DynamicObject)paramMap.get("filter_company");
        DynamicObject accountBank = (DynamicObject)paramMap.get("filter_accountbank");
        Date bizdate_startdate = (Date)paramMap.get("bizdate_startdate");
        Date bizdate_enddate = (Date)paramMap.get("bizdate_enddate");
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (company != null) {
            qFilter.and(new QFilter("company.id", "=", company.getPkValue()));
        }
        if (accountBank != null) {
            qFilter.and(new QFilter("accountbank.id", "=", accountBank.getPkValue()));
        }
        if (bizdate_startdate != null) {
            qFilter.and(new QFilter("bizdate", ">", (Object)DateUtils.truncateDate((Date)DateUtils.getNextDay((Date)bizdate_startdate, (int)-1))));
        }
        if (bizdate_enddate != null) {
            qFilter.and(new QFilter("bizdate", "<", (Object)DateUtils.truncateDate((Date)DateUtils.getNextDay((Date)bizdate_enddate, (int)1))));
        }
        qFilter.and(new QFilter("accountbank.id", "in", innerAcctIds));
        String selectTransDetailFields = "company.id,accountbank.id,currency.id,creditamount,debitamount";
        DataSet transDetailDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_transdetail", (String)selectTransDetailFields, (QFilter[])qFilter.toArray(), null).groupBy(new String[]{"company.id", "accountbank.id", "currency.id"}).sum("creditamount").sum("debitamount").finish();
        return transDetailDS;
    }

    private DataSet queryBeginBalance(Map<String, Object> paramMap, List<Long> innerAcctIds) {
        DynamicObject company = (DynamicObject)paramMap.get("filter_company");
        DynamicObject accountBank = (DynamicObject)paramMap.get("filter_accountbank");
        Date bizdate_startdate = (Date)paramMap.get("bizdate_startdate");
        Date bizdate_enddate = (Date)paramMap.get("bizdate_enddate");
        ArrayList<QFilter> balStartQFilterList = new ArrayList<QFilter>();
        if (company != null) {
            balStartQFilterList.add(new QFilter("company.id", "=", company.getPkValue()));
        }
        if (accountBank != null) {
            balStartQFilterList.add(new QFilter("accountbank.id", "=", accountBank.getPkValue()));
        }
        if (bizdate_startdate != null) {
            balStartQFilterList.add(new QFilter("bizdate", "<", (Object)DateUtils.truncateDate((Date)bizdate_startdate)));
            balStartQFilterList.add(new QFilter("accountbank.id", "in", innerAcctIds));
            DataSet beginBalanceDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ifm_accountbalance", (String)"id,accountbank.id,currency.id,currency.name,lstbalance,amount,bizdate", (QFilter[])balStartQFilterList.toArray(new QFilter[0]), null);
            DataSet bizDateDS = beginBalanceDS.groupBy(new String[]{"accountbank.id", "currency.id"}).max("bizdate").finish();
            DataSet beginBalDS = beginBalanceDS.join(bizDateDS, JoinType.INNER).on("accountbank.id", "accountbank.id").on("currency.id", "currency.id").on("bizdate", "bizdate").select(new String[]{"accountbank.id", "currency.id", "currency.name", "amount", "bizdate"}).finish();
            return beginBalDS;
        }
        RowMeta emptyRowMeta = new RowMeta(new String[]{"accountbank.id", "currency.id", "currency.name", "amount"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.StringType, DataType.BigDecimalType});
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(emptyRowMeta).build();
    }

    protected Map<String, Object> transQueryParam(ReportQueryParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(param.getFilter().getFilterItems().size());
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }
}

