/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.TreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SubsidiaryLedgerDataPlugin
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(SubsidiaryLedgerDataPlugin.class);

    public static Map<String, Object> transQueryParam(ReportQueryParam param) {
        int size = param.getFilter().getFilterItems().size();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(size);
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        paramMap.put("appid", param.getCustomParam().get("appid"));
        return paramMap;
    }

    private DataSet createEmptySet() {
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType})).build();
    }

    public DataSet query(ReportQueryParam param, Object args) throws Throwable {
        boolean showDailyAmt;
        Date endDate;
        Date beginDate;
        logger.info("query begin...");
        Map<String, Object> paramMap = SubsidiaryLedgerDataPlugin.transQueryParam(param);
        String queryType = (String)paramMap.get("filter_querytype");
        if ("period".equals(queryType)) {
            DynamicObject beginPeriod = (DynamicObject)paramMap.get("filter_beginperiod");
            DynamicObject endPeriod = (DynamicObject)paramMap.get("filter_endperiod");
            beginDate = beginPeriod.getDate("begindate");
            endDate = endPeriod.getDate("enddate");
        } else {
            beginDate = (Date)paramMap.get("filter_begindate");
            endDate = (Date)paramMap.get("filter_enddate");
        }
        Long selectedOrgId = this.getSelectedOrgId((String)args);
        if (EmptyUtil.isEmpty((Long)selectedOrgId)) {
            logger.info("empty org parameter return");
            return this.createEmptySet();
        }
        Set<Long> acctIds = this.getSelectedAcctIds(param, (String)args);
        if (acctIds == null || acctIds.isEmpty()) {
            logger.info("empty inneraccount return");
            return this.createEmptySet();
        }
        QFilter acctFilter = new QFilter("accountbank.id", "in", acctIds);
        DynamicObject currency = (DynamicObject)paramMap.get("filter_currency");
        acctFilter.and(new QFilter("currency.id", "=", currency.getPkValue()));
        DataSet beginBalDS = this.queryBeginBalance(acctFilter, beginDate);
        BigDecimal beginBalance = ((Row)beginBalDS.copy().iterator().next()).getBigDecimal("balance");
        DataSet detailDS = this.queryTransDetail(acctFilter, beginDate, endDate);
        detailDS = detailDS.addField(beginBalance.toPlainString(), "beginbalance").addBalanceField("occurbalance", "balancesum").addField("beginbalance+balancesum", "balance");
        DataSet sumBalDS = this.buildSumBalance(detailDS, beginDate, endDate, beginBalance, paramMap);
        sumBalDS = sumBalDS.select(new String[]{"0 as inneraccount", "null as settlecenter", "null as transdetailbillno", "bizdate", "null as biztime", "summary", "debitamount", "creditamount", "null as settlecenteraccno", "null as settlecenteraccname", "null as oppbank", "null as oppbanknumber", "null as oppunit", "null as sourcebillno", "null as sourcebillid", "null as sourcebilltype", "balance as balance", "datatype"});
        beginBalDS = beginBalDS.select(new String[]{"0 as inneraccount", "null as settlecenter", "null as transdetailbillno", "bizdate", "null as biztime", " null as summary", "0 as debitamount", "0 as creditamount", "null as settlecenteraccno", "null as settlecenteraccname", "null as oppbank", "null as oppbanknumber", "null as oppunit", "null as sourcebillno", "null as sourcebillid", "null as sourcebilltype", "balance as balance", "1 as datatype"}).updateField("summary", ResManager.loadKDString((String)"'\u671f\u521d\u4f59\u989d'", (String)"SubsidiaryLedgerDataPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0]));
        if (this.isSelectAcctNode((String)args) && acctIds.size() == 1) {
            Long acctId = acctIds.iterator().next();
            String idExp = String.valueOf(acctId);
            beginBalDS = beginBalDS.updateField("inneraccount", idExp);
            sumBalDS = sumBalDS.updateField("inneraccount", idExp);
            DynamicObject accDO = TmcDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountbanks", (String)"bank");
            String bankId = accDO.getDynamicObject("bank").getString("id");
            beginBalDS = beginBalDS.updateField("settlecenter", bankId);
            sumBalDS = sumBalDS.updateField("settlecenter", bankId);
        }
        detailDS = detailDS.removeFields(new String[]{"beginbalance", "balancesum", "occurbalance", "bizyear", "bizmonth"}).addField("3", "datatype");
        DataSet resultDS = beginBalDS.union(detailDS).union(sumBalDS).orderBy(new String[]{"bizdate asc", "datatype asc", "biztime asc"});
        resultDS = resultDS.addField("" + currency.getLong("id") + "", "currency");
        resultDS = resultDS.addField("" + selectedOrgId + "", "org");
        if (TmcAppEnum.IFM.getValue().equals(paramMap.get("appid"))) {
            DynamicObject settlecenter = (DynamicObject)paramMap.get("filter_settlecenter");
            resultDS = resultDS.addField("" + settlecenter.getLong("id") + "", "settlecenter");
        }
        if (!(showDailyAmt = ((Boolean)paramMap.get("showdailyamt")).booleanValue())) {
            resultDS = resultDS.filter("datatype <> 2 and datatype <> 4");
        }
        logger.info("query end return data set...");
        return resultDS;
    }

    private DataSet buildSumBalance(DataSet detailDS, Date beginDate, final Date endDate, BigDecimal beginBalance, Map<String, Object> paramMap) {
        DataSet detailDSCopy = detailDS.copy();
        if (detailDSCopy.isEmpty()) {
            paramMap.put("showdailyamt", false);
            detailDSCopy = this.getDefaultDataSet(endDate);
        }
        DataSet dayDS = detailDSCopy.groupBy(new String[]{"bizyear", "bizmonth", "bizdate"}).sum("creditamount").sum("debitamount").finish();
        DataSet dayEndDS = dayDS.copy().addField(beginBalance.toPlainString(), "beginbalance").addBalanceField("creditamount-debitamount", "balancesum").addField("beginbalance+balancesum", "balance");
        dayEndDS = dayEndDS.removeFields(new String[]{"beginbalance", "balancesum"});
        DataSet dayBeginDS = dayEndDS.copy();
        dayBeginDS = dayBeginDS.updateField("balance", "balance-creditamount+debitamount").updateField("creditamount", "0").updateField("debitamount", "0");
        DataSet monthDS = dayDS.groupBy(new String[]{"bizyear", "bizmonth"}).max("bizdate").sum("creditamount").sum("debitamount").finish();
        DataSet maxBizDateDS = monthDS.copy().groupBy().max("bizdate").finish();
        final Date maxBizDate = ((Row)maxBizDateDS.iterator().next()).getDate("bizdate");
        final RowMeta mRowMeta = monthDS.getRowMeta();
        monthDS = monthDS.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return mRowMeta;
            }

            public Object[] map(Row row) {
                Object[] rowObject = new Object[]{row.getString("bizyear"), row.getString("bizmonth"), maxBizDate.compareTo(row.getDate("bizdate")) == 0 ? maxBizDate : DateUtils.getLastDayOfMonth((Date)row.getDate("bizdate")), row.getBigDecimal("creditamount"), row.getBigDecimal("debitamount")};
                return rowObject;
            }
        });
        DataSet monthEndDS = monthDS.copy().addField(beginBalance.toPlainString(), "beginbalance").addBalanceField("creditamount-debitamount", "balancesum").addField("beginbalance+balancesum", "balance");
        monthEndDS = monthEndDS.removeFields(new String[]{"beginbalance", "balancesum"});
        DataSet monthBeginDS = monthEndDS.copy();
        monthBeginDS = monthBeginDS.updateField("balance", "balance-creditamount+debitamount");
        final RowMeta bmRowMeta = monthBeginDS.getRowMeta();
        monthBeginDS = monthBeginDS.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return bmRowMeta;
            }

            public Object[] map(Row row) {
                Object[] rowObject = new Object[]{row.getString("bizyear"), row.getString("bizmonth"), DateUtils.getFirstDayOfMonth((Date)row.getDate("bizdate")), BigDecimal.ZERO, BigDecimal.ZERO, row.getBigDecimal("balance")};
                return rowObject;
            }
        });
        HashMap<String, Date> dateFilter = new HashMap<String, Date>(16);
        dateFilter.put("datefilter", beginDate);
        monthBeginDS = monthBeginDS.where("bizdate> datefilter", dateFilter);
        DataSet monBeginMinDateDS = monthBeginDS.copy().groupBy().min("bizdate").finish();
        if (monBeginMinDateDS.hasNext()) {
            Date minMonBizdate = monBeginMinDateDS.next().getDate("bizdate");
            dateFilter.put("datefilter", minMonBizdate);
            DataSet ds = dayEndDS.copy().filter("bizdate < datefilter", dateFilter);
            if (ds.isEmpty()) {
                monthBeginDS = monthBeginDS.where("bizdate> datefilter", dateFilter);
            }
        }
        DataSet yearEndSumDS = monthDS.groupBy(new String[]{"bizyear"}).max("bizdate").sum("creditamount").sum("debitamount").finish();
        yearEndSumDS = yearEndSumDS.addField(beginBalance.toPlainString(), "beginbalance").addBalanceField("creditamount-debitamount", "balancesum").addField("beginbalance+balancesum", "balance");
        yearEndSumDS = yearEndSumDS.removeFields(new String[]{"beginbalance", "balancesum"});
        final RowMeta yRowMeta = yearEndSumDS.getRowMeta();
        yearEndSumDS = yearEndSumDS.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return yRowMeta;
            }

            public Object[] map(Row row) {
                Object[] rowObject = new Object[]{row.getString("bizyear"), endDate, row.getBigDecimal("creditamount"), row.getBigDecimal("debitamount"), row.getBigDecimal("balance")};
                return rowObject;
            }
        });
        monthBeginDS = monthBeginDS.removeFields(new String[]{"bizyear", "bizmonth"}).addField(ResManager.loadKDString((String)"'\u671f\u521d\u4f59\u989d'", (String)"SubsidiaryLedgerDataPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0]), "summary").addField("1", "datatype");
        dayBeginDS = dayBeginDS.removeFields(new String[]{"bizyear", "bizmonth"}).addField(ResManager.loadKDString((String)"'\u65e5\u521d\u4f59\u989d'", (String)"SubsidiaryLedgerDataPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]), "summary").addField("2", "datatype");
        dayEndDS = dayEndDS.removeFields(new String[]{"bizyear", "bizmonth"}).addField(ResManager.loadKDString((String)"'\u672c\u65e5\u5408\u8ba1'", (String)"SubsidiaryLedgerDataPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]), "summary").addField("4", "datatype");
        monthEndDS = monthEndDS.removeFields(new String[]{"bizyear", "bizmonth"}).addField(ResManager.loadKDString((String)"'\u672c\u671f\u5408\u8ba1'", (String)"SubsidiaryLedgerDataPlugin_3", (String)"tmc-ifm-report", (Object[])new Object[0]), "summary").addField("5", "datatype");
        yearEndSumDS = yearEndSumDS.removeFields(new String[]{"bizyear"}).addField(ResManager.loadKDString((String)"'\u672c\u5e74\u7d2f\u8ba1'", (String)"SubsidiaryLedgerDataPlugin_4", (String)"tmc-ifm-report", (Object[])new Object[0]), "summary").addField("6", "datatype");
        return monthBeginDS.union(dayBeginDS).union(dayEndDS).union(monthEndDS).union(yearEndSumDS);
    }

    private DataSet queryBeginBalance(QFilter acctFilter, Date beginDate) {
        Set acctIds = (Set)acctFilter.getValue();
        QFilter dateFilter = new QFilter("bizdate", "=", (Object)beginDate);
        DataSet beginBalDS = QueryServiceHelper.queryDataSet((String)"querybalance", (String)"ifm_accountbalance", (String)"accountbank.id accountid, lstbalance, currency currencyid, bizdate", (QFilter[])new QFilter[]{acctFilter, dateFilter}, null);
        DataSet balDSCopy = beginBalDS.copy();
        Iterator rowIter = balDSCopy.iterator();
        HashSet noInitBalIds = new HashSet();
        HashSet<Long> hasInitBalIds = new HashSet<Long>();
        while (rowIter.hasNext()) {
            Row balRow = (Row)rowIter.next();
            Long acctId = balRow.getLong("accountid");
            hasInitBalIds.add(acctId);
        }
        acctIds.stream().forEach(a -> {
            if (!hasInitBalIds.contains(a)) {
                noInitBalIds.add(a);
            }
        });
        QFilter preBalFilter = new QFilter("accountbank.id", "in", noInitBalIds);
        preBalFilter.and(new QFilter("bizdate", "<=", (Object)beginDate));
        DataSet preBizDateDS = QueryServiceHelper.queryDataSet((String)"querybalance", (String)"ifm_accountbalance", (String)"accountbank.id accountid, bizdate", (QFilter[])preBalFilter.toArray(), null);
        preBizDateDS = preBizDateDS.groupBy(new String[]{"accountid"}).max("bizdate").finish();
        Iterator preIter = preBizDateDS.iterator();
        QFilter preQFilter = null;
        while (preIter.hasNext()) {
            Row balRow = (Row)preIter.next();
            QFilter qf = new QFilter("accountbank.id ", "=", (Object)balRow.getLong("accountid"));
            qf.and("bizdate", "=", (Object)balRow.getDate("bizdate"));
            if (preQFilter == null) {
                preQFilter = qf;
                continue;
            }
            preQFilter.or(qf);
        }
        DataSet preBizDateBalDS = null;
        if (preQFilter != null) {
            preBizDateBalDS = QueryServiceHelper.queryDataSet((String)"querybalance", (String)"ifm_accountbalance", (String)"accountbank.id accountid, amount as lstbalance, currency currencyid, bizdate", (QFilter[])preQFilter.toArray(), null);
        }
        if (preBizDateBalDS != null) {
            beginBalDS = beginBalDS.union(preBizDateBalDS);
        }
        beginBalDS = beginBalDS.groupBy().sum("lstbalance", "balance").finish();
        RowMeta rm = new RowMeta(new String[]{"bizdate", "balance"}, new DataType[]{DataType.TimestampType, DataType.BigDecimalType});
        DataSetBuilder builder = Algo.create((String)"beginBalanceDS").createDataSetBuilder(rm);
        BigDecimal balance = BigDecimal.ZERO;
        if (!beginBalDS.isEmpty()) {
            balance = beginBalDS.next().getBigDecimal("balance");
        }
        builder.append(new Object[]{beginDate, balance});
        beginBalDS.close();
        return builder.build();
    }

    private DataSet queryTransDetail(QFilter acctFilter, Date beginDate, Date endDate) {
        QFilter detailQF = new QFilter("bizdate", ">=", (Object)beginDate);
        detailQF.and(new QFilter("bizdate", "<=", (Object)endDate));
        detailQF.and(acctFilter);
        DataSet detailDS = QueryServiceHelper.queryDataSet((String)"querytransdetail", (String)"ifm_transdetail", (String)"accountbank.id as inneraccount, bank.id as settlecenter, billno transdetailbillno,  bizdate, biztime, description as summary, debitamount, creditamount,settlecenteraccno, settlecenteraccname, oppbank, oppbanknumber,oppunit, bizrefno as sourcebillno, sourcebillid, sourcebilltype, creditamount-debitamount as occurbalance", (QFilter[])detailQF.toArray(), (String)"bizdate asc, biztime asc");
        detailDS = detailDS.addField("Year(bizdate)", "bizyear").addField("Month(bizdate)", "bizmonth");
        return detailDS;
    }

    private boolean isSelectAcctNode(String args) {
        return args.indexOf("-") > -1;
    }

    private Long getSelectedOrgId(String args) {
        if (EmptyUtil.isEmpty((String)args)) {
            return 0L;
        }
        if (args.indexOf("-") > -1) {
            return Long.parseLong(args.split("-")[1]);
        }
        return Long.parseLong(args);
    }

    private Set<Long> getSelectedAcctIds(ReportQueryParam param, String args) throws NoSuchFieldException, IllegalAccessException {
        String pageId = (String)param.getCustomParam().get("pageid");
        TreeModel treeModel = ReportCacheManager.getInstance().getCache().getReportTreeModel(pageId);
        HashSet<Long> leafIds = new HashSet<Long>(10);
        TreeNode node = this.getTreeNode(treeModel, args);
        if (node == null) {
            return leafIds;
        }
        List chNodes = node.getChildren();
        if (chNodes == null) {
            leafIds.add(Long.parseLong(node.getId().split("-")[0]));
        } else {
            chNodes.forEach(n -> {
                if (n.getChildren() == null) {
                    leafIds.add(Long.parseLong(n.getId().split("-")[0]));
                }
            });
        }
        return leafIds;
    }

    private TreeNode getTreeNode(TreeModel treeModel, String nodeId) {
        List<TreeNode> nodes = treeModel.getNodes();
        nodes = this.genTreeStructure(nodes);
        for (TreeNode node : nodes) {
            List pathNodes = node.getChildPathNodes(nodeId);
            if (pathNodes == null || pathNodes.isEmpty()) continue;
            return (TreeNode)pathNodes.get(pathNodes.size() - 1);
        }
        return null;
    }

    private List<TreeNode> genTreeStructure(List<TreeNode> nodes) {
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : nodes) {
            nodeMap.put(node.getId(), node);
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        for (TreeNode node : nodes) {
            if (node.getParentid() == null) {
                node.setParentid("");
                nodeList.add(node);
                continue;
            }
            TreeNode p = (TreeNode)nodeMap.get(node.getParentid());
            if (p == null) {
                node.setParentid("");
                nodeList.add(node);
                continue;
            }
            ArrayList<TreeNode> children = p.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                p.setChildren(children);
            }
            children.add(node);
        }
        return nodeList;
    }

    public DataSet getDefaultDataSet(Date endDate) {
        ArrayList<Object[]> cnyList = new ArrayList<Object[]>();
        ArrayList<Field> field = new ArrayList<Field>(4);
        field.add(new Field("bizyear", (DataType)DataType.IntegerType));
        field.add(new Field("bizmonth", (DataType)DataType.IntegerType));
        field.add(new Field("bizdate", (DataType)DataType.DateType));
        field.add(new Field("creditamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("debitamount", (DataType)DataType.BigDecimalType));
        cnyList.add(new Object[]{DateUtils.getYear((Date)endDate), DateUtils.getMonth((Date)endDate), endDate, Constants.ZERO, Constants.ZERO});
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        return Algo.create((String)"DepositSumRptDataListPlugin.getExchgRateDataSet").createDataSet(cnyList.iterator(), rowMeta);
    }
}

