/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.DateTypeEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.report.helper.ReportHelper;

public class AvgBalanceReportFormListPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            Object settlementcenter = filterInfo.getValue("filter_settlementcenter");
            if (settlementcenter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceCompareFormPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]));
                return false;
            }
            Object sdate = filterInfo.getValue("filter_startdate");
            if (sdate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AvgBalanceReportFormListPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Object edate = filterInfo.getValue("filter_enddate");
            if (edate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AvgBalanceReportFormListPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            String type = (String)filterInfo.getValue("filter_type");
            String startSeason = (String)filterInfo.getValue("filter_startseason");
            String endSeason = (String)filterInfo.getValue("filter_endseason");
            if (DateTypeEnum.SEASON.getValue().equals(type) && (EmptyUtil.isEmpty((String)startSeason) || EmptyUtil.isEmpty((String)endSeason))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b63\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AvgBalanceReportFormListPlugin_3", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (DateTypeEnum.SEASON.getValue().equals(type) && ((Date)sdate).getYear() == ((Date)edate).getYear() && Integer.parseInt(startSeason) > Integer.parseInt(endSeason)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u5b63\u5ea6\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u5b63\u5ea6\u3002", (String)"AvgBalanceReportFormListPlugin_4", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String type = (String)this.getModel().getValue("filter_type");
        Date startDate = evt.getFilter().getFilterItem("filter_startdate").getDate();
        Date endDate = evt.getFilter().getFilterItem("filter_enddate").getDate();
        if (Objects.nonNull(startDate) && Objects.nonNull(endDate)) {
            SimpleDateFormat sdfs = new SimpleDateFormat("yyyy-MM-dd");
            String startDateStr = sdfs.format(startDate);
            String endDateStr = sdfs.format(endDate);
            String displayStr = evt.getFormatedFilterString();
            if (DateTypeEnum.MONTH.getValue().equals(type)) {
                displayStr = displayStr.replace(startDateStr, startDateStr.substring(0, 7));
                displayStr = displayStr.replace(endDateStr, endDateStr.substring(0, 7));
            } else if (DateTypeEnum.SEASON.getValue().equals(type)) {
                String startSeason = evt.getFilter().getFilterItem("filter_startseason").getString();
                String endSeason = evt.getFilter().getFilterItem("filter_endseason").getString();
                String yearTrans = ResManager.loadKDString((String)"\u5e74", (String)"AvgBalanceReportFormListPlugin_5", (String)"tmc-ifm-report", (Object[])new Object[0]);
                String seasonTrans = ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"AvgBalanceReportFormListPlugin_6", (String)"tmc-ifm-report", (Object[])new Object[0]);
                displayStr = displayStr.replace(startDateStr, startDateStr.substring(0, 4) + yearTrans + startSeason + seasonTrans);
                displayStr = displayStr.replace(endDateStr, endDateStr.substring(0, 4) + yearTrans + endSeason + seasonTrans);
            } else if (DateTypeEnum.YEAR.getValue().equals(type)) {
                displayStr = displayStr.replace(startDateStr, startDateStr.substring(0, 4));
                displayStr = displayStr.replace(endDateStr, endDateStr.substring(0, 4));
            }
            evt.setFormatedFilterString(displayStr);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        this.getModel().setValue("filter_settlementcenter", (Object)ReportHelper.getFinOrgDefaultValue(appId, this.getModel().getDataEntityType().getName()));
        this.getModel().setValue("filter_type", (Object)"2");
        HashMap<String, String> dateformat = new HashMap<String, String>(2);
        HashMap<String, String> startText = new HashMap<String, String>(2);
        HashMap<String, String> endText = new HashMap<String, String>(2);
        HashMap<String, HashMap<String, String>> startItem = new HashMap<String, HashMap<String, String>>(2);
        HashMap<String, HashMap<String, String>> endItem = new HashMap<String, HashMap<String, String>>(2);
        dateformat.put("mask", "YYYY-MM");
        startItem.put("item", dateformat);
        endItem.put("item", dateformat);
        startText.put("zh_CN", ResManager.loadKDString((String)"\u5f00\u59cb\u5e74\u6708", (String)"AvgBalanceReportFormListPlugin_9", (String)"tmc-ifm-report", (Object[])new Object[0]));
        startItem.put("caption", startText);
        endText.put("zh_CN", ResManager.loadKDString((String)"\u7ed3\u675f\u5e74\u6708", (String)"AvgBalanceReportFormListPlugin_10", (String)"tmc-ifm-report", (Object[])new Object[0]));
        endItem.put("caption", endText);
        this.getView().updateControlMetadata("filter_startdate", startItem);
        this.getView().updateControlMetadata("filter_enddate", endItem);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settleCenter = (BasedataEdit)this.getControl("filter_settlementcenter");
        settleCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("filter_company");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inneraccount = (BasedataEdit)this.getControl("filter_bankaccount");
        inneraccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "filter_company": 
            case "filter_settlementcenter": 
            case "filter_currency": 
            case "filter_acctuseage": 
            case "filter_isincludeclose": {
                this.getModel().setValue("filter_bankaccount", null);
                break;
            }
            case "filter_type": {
                this.setDateByType((String)e.getChangeSet()[0].getNewValue());
                break;
            }
            case "filter_startdate": {
                Date startdate = (Date)e.getChangeSet()[0].getNewValue();
                HashMap<String, Date> minMap = new HashMap<String, Date>(1);
                HashMap<String, HashMap<String, Date>> itemMap = new HashMap<String, HashMap<String, Date>>(1);
                minMap.put("min", startdate);
                itemMap.put("item", minMap);
                this.getView().updateControlMetadata("filter_enddate", itemMap);
                break;
            }
            case "filter_enddate": {
                Date enddate = (Date)e.getChangeSet()[0].getNewValue();
                HashMap<String, Date> maxMap = new HashMap<String, Date>(1);
                HashMap<String, HashMap<String, Date>> sitemMap = new HashMap<String, HashMap<String, Date>>(1);
                maxMap.put("max", enddate);
                sitemMap.put("item", maxMap);
                this.getView().updateControlMetadata("filter_startdate", sitemMap);
            }
        }
    }

    private void setDateByType(String type) {
        this.getModel().setValue("filter_startseason", null);
        this.getModel().setValue("filter_endseason", null);
        HashMap<String, String> dateformat = new HashMap<String, String>(2);
        HashMap<String, String> startText = new HashMap<String, String>(2);
        HashMap<String, String> endText = new HashMap<String, String>(2);
        HashMap<String, HashMap<String, String>> startItem = new HashMap<String, HashMap<String, String>>(2);
        HashMap<String, HashMap<String, String>> endItem = new HashMap<String, HashMap<String, String>>(2);
        if (DateTypeEnum.DAY.getValue().equals(type)) {
            dateformat.put("mask", "YYYY-MM-DD");
            startItem.put("item", dateformat);
            endItem.put("item", dateformat);
            startText.put("zh_CN", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"AvgBalanceReportFormListPlugin_7", (String)"tmc-ifm-report", (Object[])new Object[0]));
            startItem.put("caption", startText);
            endText.put("zh_CN", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"AvgBalanceReportFormListPlugin_8", (String)"tmc-ifm-report", (Object[])new Object[0]));
            endItem.put("caption", endText);
        } else if (DateTypeEnum.MONTH.getValue().equals(type)) {
            dateformat.put("mask", "YYYY-MM");
            startItem.put("item", dateformat);
            endItem.put("item", dateformat);
            startText.put("zh_CN", ResManager.loadKDString((String)"\u5f00\u59cb\u5e74\u6708", (String)"AvgBalanceReportFormListPlugin_9", (String)"tmc-ifm-report", (Object[])new Object[0]));
            startItem.put("caption", startText);
            endText.put("zh_CN", ResManager.loadKDString((String)"\u7ed3\u675f\u5e74\u6708", (String)"AvgBalanceReportFormListPlugin_10", (String)"tmc-ifm-report", (Object[])new Object[0]));
            endItem.put("caption", endText);
        } else if (DateTypeEnum.SEASON.getValue().equals(type) || DateTypeEnum.YEAR.getValue().equals(type)) {
            dateformat.put("mask", "YYYY");
            startItem.put("item", dateformat);
            endItem.put("item", dateformat);
            startText.put("zh_CN", ResManager.loadKDString((String)"\u5f00\u59cb\u5e74\u4efd", (String)"AvgBalanceReportFormListPlugin_13", (String)"tmc-ifm-report", (Object[])new Object[0]));
            startItem.put("caption", startText);
            endText.put("zh_CN", ResManager.loadKDString((String)"\u7ed3\u675f\u5e74\u4efd", (String)"AvgBalanceReportFormListPlugin_14", (String)"tmc-ifm-report", (Object[])new Object[0]));
            endItem.put("caption", endText);
            String season = this.getCurrentSeason();
            this.getModel().setValue("filter_startseason", (Object)season);
            this.getModel().setValue("filter_endseason", (Object)season);
        }
        this.getView().updateControlMetadata("filter_startdate", startItem);
        this.getView().updateControlMetadata("filter_enddate", endItem);
    }

    private void settlecenterF7(BeforeF7SelectEvent evt) {
        String appid = evt.getFormShowParameter().getAppId();
        if (EmptyUtil.isEmpty((String)appid)) {
            appid = TmcAppEnum.IFM.getValue();
        }
        List scIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)appid, (String)"ifm_avgbalancerpt", (String)"47150e89000000ac");
        QFilter filter = new QFilter("id", "in", (Object)scIds);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void accountF7(BeforeF7SelectEvent evt) {
        DynamicObjectCollection currencys;
        List currencyIds;
        DynamicObjectCollection userages;
        List useIds;
        QFilter acctQF = new QFilter("inneracct", "!=", (Object)0);
        DynamicObjectCollection settleCenter = (DynamicObjectCollection)this.getModel().getValue("filter_settlementcenter");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)settleCenter)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ed3\u7b97\u4e2d\u5fc3", (String)"AvgBalanceReportFormListPlugin_15", (String)"tmc-ifm-report", (Object[])new Object[0]));
            return;
        }
        List settleCenterIds = settleCenter.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        acctQF.and(new QFilter("bank", "in", settleCenterIds));
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_company");
        List orgIds = orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(orgIds)) {
            acctQF.and(new QFilter("company", "in", orgIds));
        }
        if (EmptyUtil.isNoEmpty(useIds = (userages = (DynamicObjectCollection)this.getModel().getValue("filter_acctuseage")).stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()))) {
            acctQF.and(new QFilter("acctproperty", "in", useIds));
        }
        if (!((Boolean)this.getModel().getValue("filter_isincludeclose")).booleanValue()) {
            acctQF.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
        }
        if (EmptyUtil.isNoEmpty(currencyIds = (currencys = (DynamicObjectCollection)this.getModel().getValue("filter_currency")).stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()))) {
            acctQF.and(new QFilter("currency.fbasedataid.id", "in", currencyIds));
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237", (String)"SubsidiaryLedgerListPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]));
        showParameter.getListFilterParameter().getQFilters().add(acctQF);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop;
        switch (prop = evt.getProperty().getName()) {
            case "filter_settlementcenter": {
                this.settlecenterF7(evt);
                break;
            }
            case "filter_bankaccount": {
                this.accountF7(evt);
            }
        }
    }

    private String getCurrentSeason() {
        Calendar now = Calendar.getInstance();
        String season = null;
        int month = now.get(2) + 1;
        if (month == 1 || month == 2 || month == 3) {
            season = "1";
        } else if (month == 4 || month == 5 || month == 6) {
            season = "2";
        } else if (month == 7 || month == 8 || month == 9) {
            season = "3";
        } else if (month == 10 || month == 11 || month == 12) {
            season = "4";
        }
        return season;
    }
}

