/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.enums.AcctClassifyEnum;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.report.helper.ReportHelper;

public class BalanceReportFormListPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public static final String SUMLEVEL = "0";
    public static final String SUB_TATOLL = "1";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settleCenterF7 = (BasedataEdit)this.getControl("filter_settlementcenter");
        settleCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bankAccountF7 = (BasedataEdit)this.getControl("filter_bankaccount");
        bankAccountF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit beginPeriodF7 = (BasedataEdit)this.getControl("filter_beginperiod");
        beginPeriodF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endPeriodF7 = (BasedataEdit)this.getControl("filter_endperiod");
        endPeriodF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject settleId = IfmSettleCenterHelper.getSettleFinByOrg((Long)RequestContext.get().getOrgId());
        if (EmptyUtil.isNoEmpty((DynamicObject)settleId)) {
            this.getModel().setValue("filter_settlementcenter", settleId.getPkValue());
            this.settleCenterProp();
            this.queryTypeProp();
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            List settleIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"ifm_balancerpt", (String)"47150e89000000ac");
            if (EmptyUtil.isNoEmpty((Object)settleIds)) {
                this.getModel().setValue("filter_settlementcenter", settleIds.get(0));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String prop;
        switch (prop = event.getProperty().getName()) {
            case "filter_settlementcenter": {
                this.settleF7Select(event);
                break;
            }
            case "filter_bankaccount": {
                this.bankAccountF7Select(event);
                break;
            }
            case "filter_beginperiod": 
            case "filter_endperiod": {
                this.periodDate(event);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        switch (prop = e.getProperty().getName()) {
            case "filter_settlementcenter": {
                this.settleCenterProp();
                break;
            }
            case "filter_querytype": {
                this.queryTypeProp();
                this.defaultPeriod();
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean mustCheck;
        FilterInfo filterInfo = queryParam.getFilter();
        boolean isCenter = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String)"filter_settlementcenter");
        if (!isCenter) {
            return false;
        }
        String queryType = (String)this.getModel().getValue("filter_querytype");
        Date beginDate = null;
        Date endDate = null;
        if ("period".equals(queryType)) {
            mustCheck = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"filter_beginperiod", "filter_beginperiod"});
            if (!mustCheck) {
                return mustCheck;
            }
            DynamicObject beginPeriod = (DynamicObject)this.getModel().getValue("filter_beginperiod");
            DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("filter_endperiod");
            if (null == beginPeriod) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"BalanceReportFormListPlugin_5", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (null == endPeriod) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"BalanceReportFormListPlugin_6", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            beginDate = beginPeriod.getDate("begindate");
            if (beginDate.after(endDate = endPeriod.getDate("enddate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u671f\u95f4", (String)"BalanceReportFormListPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        } else {
            mustCheck = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"filter_begindate", "filter_enddate"});
            if (!mustCheck) {
                return mustCheck;
            }
            beginDate = (Date)this.getModel().getValue("filter_begindate");
            endDate = (Date)this.getModel().getValue("filter_enddate");
        }
        if (!(mustCheck = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"filter_currency", "filter_currencyunit"}))) {
            return false;
        }
        filterInfo.addFilterItem("filter_begindate", (Object)beginDate);
        filterInfo.addFilterItem("filter_enddate", (Object)endDate);
        DynamicObject center = (DynamicObject)this.getModel().getValue("filter_settlementcenter");
        Long exchageTableId = TmcBusinessBaseHelper.getExchageTableId((Long)center.getDynamicObject("org").getLong("id"));
        if (EmptyUtil.isEmpty((Long)exchageTableId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u5143\u672a\u5173\u8054\u6c47\u7387\u8868", (String)"BalanceReportFormListPlugin_1", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        filterInfo.addFilterItem("exchageTableId", (Object)exchageTableId);
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_currency");
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("filter_currency", currency.getPkValue());
        filter.addFilterItem("filter_currencyunit", (Object)currencyUnit);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        if (opKey.equals("details") && evt.getOperationResult().isSuccess()) {
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            IReportListModel reportModel = reportList.getReportModel();
            int rowIdx = this.getView().getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = reportModel.getRowData(rowIdx);
            ReportShowParameter param = new ReportShowParameter();
            Map customParams = param.getCustomParams();
            DynamicObject center = (DynamicObject)this.getModel().getValue("filter_settlementcenter");
            customParams.put("filter_settlementcenter", center != null ? center.getPkValue() : center);
            DynamicObjectCollection companys = (DynamicObjectCollection)this.getModel().getValue("filter_company");
            Set companyIds = companys.parallelStream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            customParams.put("filter_company", companyIds);
            customParams.put("filter_close", this.getModel().getValue("filter_close"));
            DynamicObjectCollection accounts = (DynamicObjectCollection)this.getModel().getValue("filter_bankaccount");
            Set accountIds = accounts.parallelStream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            customParams.put("filter_bankaccount", accountIds);
            customParams.put("filter_querytype", this.getModel().getValue("filter_querytype"));
            DynamicObject periodType = (DynamicObject)this.getModel().getValue("filter_periodtype");
            customParams.put("filter_periodtype", periodType != null ? periodType.getPkValue() : null);
            DynamicObject beginPeriod = (DynamicObject)this.getModel().getValue("filter_beginperiod");
            customParams.put("filter_beginperiod", beginPeriod != null ? beginPeriod.getPkValue() : null);
            DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("filter_endperiod");
            customParams.put("filter_endperiod", endPeriod != null ? endPeriod.getPkValue() : null);
            customParams.put("filter_begindate", this.getModel().getValue("filter_begindate"));
            customParams.put("filter_enddate", this.getModel().getValue("filter_enddate"));
            customParams.put("filter_currency", this.getModel().getValue("filter_currency"));
            customParams.put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
            String sumlevel = EmptyUtil.isNoEmpty((DynamicObject)rowData) ? rowData.getString("sumlevel") : "";
            String msg = "";
            if (SUMLEVEL.equals(sumlevel)) {
                String bankAccount = rowData.getString("account");
                DynamicObject originalCurr = rowData.getDynamicObject("originalcurrency");
                Long accountId = this.getBaseDataId(bankAccount, "bd_accountbanks", "bankaccountnumber");
                if (EmptyUtil.isNoEmpty((Long)accountId)) {
                    customParams.put("filter_bankaccount", Collections.singletonList(accountId));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)originalCurr)) {
                    customParams.put("filter_orgcurrency", originalCurr.getPkValue());
                }
            } else if (SUB_TATOLL.equals(sumlevel)) {
                String company = rowData.getString("company");
                Long orgId = this.getBaseDataId(company, "bos_org", "name");
                if (EmptyUtil.isNoEmpty((Long)orgId)) {
                    customParams.put("filter_company", Collections.singletonList(orgId));
                }
                msg = this.checkMultCurrency(customParams, rowIdx);
            } else {
                msg = this.checkMultCurrency(customParams, rowIdx);
            }
            if (EmptyUtil.isNoEmpty((String)msg)) {
                this.getView().showTipNotification(msg, Integer.valueOf(6000));
                return;
            }
            param.setFormId("ifm_subsidiaryledger");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private String checkMultCurrency(Map<String, Object> customParams, int rowIdx) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIdx);
        String sumlevel = rowData.getString("sumlevel");
        HashSet<Long> currencyIds = new HashSet<Long>();
        if (SUB_TATOLL.equals(sumlevel)) {
            String companyName = rowData.getString("company");
            for (int i = rowIdx - 1; i > 0 && !SUB_TATOLL.equals(sumlevel = (rowData = reportModel.getRowData(i)).getString("sumlevel")); --i) {
                DynamicObject rowCurrency = rowData.getDynamicObject("originalcurrency");
                if (!EmptyUtil.isNoEmpty((DynamicObject)rowCurrency)) continue;
                currencyIds.add(rowCurrency.getLong("id"));
            }
            if (currencyIds.size() > 1) {
                return ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8%s\u5b58\u5728\u4e0d\u540c\u5e01\u79cd\u7684\u5185\u90e8\u8d26\u6237\uff0c\u4e0d\u652f\u6301\u5173\u8054\u67e5\u8be2", (String)"BalanceReportFormListPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[]{companyName});
            }
        } else {
            for (int i = rowIdx - 1; i > 0; --i) {
                DynamicObject rowCurrency;
                rowData = reportModel.getRowData(i);
                sumlevel = rowData.getString("sumlevel");
                if (SUB_TATOLL.equals(sumlevel) || !EmptyUtil.isNoEmpty((DynamicObject)(rowCurrency = rowData.getDynamicObject("originalcurrency")))) continue;
                currencyIds.add(rowCurrency.getLong("id"));
            }
            if (currencyIds.size() > 1) {
                DynamicObject center = (DynamicObject)this.getModel().getValue("filter_settlementcenter");
                return ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3%s\u5b58\u5728\u4e0d\u540c\u5e01\u79cd\u7684\u5185\u90e8\u8d26\u6237\uff0c\u4e0d\u652f\u6301\u5173\u8054\u67e5\u8be2", (String)"BalanceReportFormListPlugin_3", (String)"tmc-ifm-report", (Object[])new Object[]{center != null ? center.getString("name") : ""});
            }
        }
        if (currencyIds.size() > 0) {
            customParams.put("filter_orgcurrency", currencyIds.iterator().next());
        }
        return "";
    }

    private void queryTypeProp() {
        String queryType = (String)this.getModel().getValue("filter_querytype");
        boolean isPeriod = "period".equals(queryType);
        String beginField = isPeriod ? "filter_begindate" : "filter_beginperiod";
        String endField = isPeriod ? "filter_enddate" : "filter_endperiod";
        this.getModel().setValue(beginField, null);
        this.getModel().setValue(endField, null);
    }

    private void periodDate(BeforeF7SelectEvent event) {
        DynamicObject periodType = (DynamicObject)this.getModel().getValue("filter_periodtype");
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (periodType != null) {
            QFilter qFilter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
            qFilter.and("isadjustperiod", "=", (Object)SUMLEVEL);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void bankAccountF7Select(BeforeF7SelectEvent event) {
        DynamicObjectCollection currencyList;
        DynamicObjectCollection companyList;
        ListShowParameter showPara = (ListShowParameter)event.getFormShowParameter();
        boolean isClose = (Boolean)this.getModel().getValue("filter_close");
        List qFilters = showPara.getListFilterParameter().getQFilters();
        DynamicObject finOrg = (DynamicObject)this.getModel().getValue("filter_settlementcenter");
        if (finOrg != null) {
            qFilters.add(new QFilter("bank.id", "=", finOrg.getPkValue()));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(companyList = (DynamicObjectCollection)this.getModel().getValue("filter_company")))) {
            List list = companyList.parallelStream().map(e -> e.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            qFilters.add(new QFilter("company.id", "in", list));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencyList = (DynamicObjectCollection)this.getModel().getValue("filter_orgcurrency")))) {
            List list = currencyList.parallelStream().map(e -> e.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            qFilters.add(new QFilter("currency.fbasedataid", "in", list));
        }
        qFilters.add(new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue()));
        if (!isClose) {
            qFilters.add(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
        }
    }

    private void settleF7Select(BeforeF7SelectEvent event) {
        String appId = this.getView().getFormShowParameter().getAppId();
        ListShowParameter showPara = (ListShowParameter)event.getFormShowParameter();
        List settleIds = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"ifm_balancerpt", (String)"47150e89000000ac");
        showPara.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)settleIds));
    }

    private void settleCenterProp() {
        DynamicObject org;
        DynamicObject settle = (DynamicObject)this.getModel().getValue("filter_settlementcenter");
        this.getModel().setValue("filter_company", null);
        this.getModel().setValue("filter_bankaccount", null);
        String queryType = (String)this.getModel().getValue("filter_querytype");
        if (EmptyUtil.isNoEmpty((DynamicObject)settle) && "period".equals(queryType) && EmptyUtil.isNoEmpty((DynamicObject)(org = settle.getDynamicObject("org")))) {
            DynamicObject baseCurrency = ReportHelper.getBaseCurrency(org.getLong("id"));
            this.getModel().setValue("filter_currency", baseCurrency != null ? baseCurrency.getPkValue() : null);
            DynamicObject casInit = TmcBusinessBaseHelper.getSystemStatusCtrol((long)org.getLong("id"));
            if (EmptyUtil.isEmpty((DynamicObject)casInit) || EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("periodtype"))) {
                this.getModel().setValue("filter_periodtype", null);
                this.getModel().setValue("filter_beginperiod", null);
                this.getModel().setValue("filter_endperiod", null);
                this.getModel().setValue("filter_querytype", (Object)"date");
            } else {
                DynamicObject periodType = casInit.getDynamicObject("periodtype");
                this.getModel().setValue("filter_periodtype", (Object)periodType.getLong("id"));
                this.defaultPeriod();
            }
        }
    }

    private void defaultPeriod() {
        String queryType = (String)this.getModel().getValue("filter_querytype");
        if ("period".equals(queryType)) {
            DynamicObject periodType = (DynamicObject)this.getModel().getValue("filter_periodtype");
            if (EmptyUtil.isEmpty((DynamicObject)periodType)) {
                return;
            }
            DynamicObject periodByDate = ReportHelper.getPeriodByDate(DateUtils.getCurrentDate(), periodType.getLong("id"));
            this.getModel().setValue("filter_beginperiod", (Object)periodByDate);
            this.getModel().setValue("filter_endperiod", (Object)periodByDate);
        } else {
            Date date = DateUtils.getCurrentDate();
            this.getModel().setValue("filter_begindate", (Object)date);
            this.getModel().setValue("filter_enddate", (Object)date);
        }
    }

    private Long getBaseDataId(String name, String entityName, String field) {
        Map bases = TmcDataServiceHelper.loadFromCache((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{new QFilter(field, "=", (Object)name)});
        if (EmptyUtil.isNoEmpty((Object)bases) && bases.size() > 0) {
            return ((DynamicObject)bases.entrySet().iterator().next().getValue()).getLong("id");
        }
        return null;
    }
}

