/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.form;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.ifm.helper.IfmSettleCenterHelper;
import kd.tmc.ifm.helper.InterestCalcHelper;

public class DepositInterestCalcFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settleCenterF7 = (BasedataEdit)this.getControl("filter_settlecenter");
        settleCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit intObjectF7 = (BasedataEdit)this.getControl("filter_intobject");
        intObjectF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit exRateTableF7 = (BasedataEdit)this.getControl("filter_exratetable");
        exRateTableF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.intDefaultValue();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName;
        switch (propName = evt.getProperty().getName()) {
            case "filter_settlecenter": {
                this.setSettleCenterF7Filter(evt);
                break;
            }
            case "filter_intobject": {
                this.setIntObjectF7Filter(evt);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"origccy_interestamt")) {
            ReportList reportList = (ReportList)event.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            FormShowParameter parameter = new FormShowParameter();
            DynamicObject rowData = reportModel.getRowData(event.getRowIndex());
            this.initViewParam(rowData, parameter);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setFormId("ifm_intbill_detail");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "filter_settlecenter": {
                this.getModel().setValue("filter_intobject", null);
                DynamicObject settleCenter = (DynamicObject)e.getChangeSet()[0].getNewValue();
                Long settleCenterId = EmptyUtil.isEmpty((DynamicObject)settleCenter) ? 0L : settleCenter.getLong("id");
                this.setExRateTable(settleCenterId);
                break;
            }
            case "filter_currency": 
            case "filter_company": {
                this.getModel().setValue("filter_intobject", null);
                break;
            }
            case "filter_unit": 
            case "filter_reportcurrency": {
                this.autoSearch();
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.initQueryParam(queryParam);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (EmptyUtil.isNoEmpty((Object)filterInfo)) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_settlecenter"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositInterestCalcFormPlugin_5", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Date startDate = filterInfo.getFilterItem("filter_interestdatestart").getDate();
            Date endDate = filterInfo.getFilterItem("filter_interestdateend").getDate();
            if (EmptyUtil.isEmpty((Object)endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u606f\u7ed3\u675f\u65e5\u671f\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"DepositInterestCalcFormPlugin_3", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (startDate != null && endDate.before(startDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u606f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8ba1\u606f\u5f00\u59cb\u65e5\u671f", (String)"DepositInterestCalcFormPlugin_4", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            DynamicObject exRateTable = (DynamicObject)filterInfo.getValue("filter_exratetable");
            if (exRateTable == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u4e2d\u8bbe\u7f6e\u6c47\u7387\u8868\u3002", (String)"DepositInterestCalcFormPlugin_6", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_reportcurrency"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositInterestCalcFormPlugin_2", (String)"tmc-ifm-report", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private void initQueryParam(ReportQueryParam queryParam) {
        Map customParam = queryParam.getCustomParam();
        customParam.clear();
        DynamicObject rptCurrency = (DynamicObject)this.getModel().getValue("filter_reportcurrency");
        customParam.put("reportCurrencyId", rptCurrency.getPkValue());
        String unit = (String)this.getModel().getValue("filter_unit");
        customParam.put("filter_unit", unit);
        List filterItems = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            Object filterValue = filterItem.getValue();
            if (EmptyUtil.isEmpty((Object)filterValue)) continue;
            String propName = filterItem.getPropName();
            if (filterValue instanceof DynamicObjectCollection) {
                List idList = ((DynamicObjectCollection)filterValue).stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                customParam.put(propName, idList);
                continue;
            }
            if (filterValue instanceof DynamicObject) {
                customParam.put(propName, ((DynamicObject)filterValue).getPkValue());
                continue;
            }
            customParam.put(propName, filterValue);
        }
    }

    private void intDefaultValue() {
        long orgId;
        DynamicObject currency;
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObject currentPermOrg = TmcOrgDataHelper.getCurrentPermOrg((String)appId, (String)"ifm_inerestcalculationrpt", (String)"47150e89000000ac");
        Set settleCenterIds = SettleCenterHelper.getAuthorizedSettleCenterIds(Collections.singletonList(currentPermOrg.getLong("id")));
        if (EmptyUtil.isNoEmpty((Object)settleCenterIds)) {
            Long settleCenterId = (Long)settleCenterIds.iterator().next();
            this.getModel().setValue("filter_settlecenter", (Object)settleCenterId);
            this.setExRateTable(settleCenterId);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(currency = TmcBusinessBaseHelper.getBaseCurrency((long)(orgId = TmcOrgDataHelper.getCurrentOrgId()))))) {
            this.getModel().setValue("filter_reportcurrency", currency.get("id"));
        }
    }

    private void setSettleCenterF7Filter(BeforeF7SelectEvent evt) {
        ListShowParameter showPara = (ListShowParameter)evt.getFormShowParameter();
        List finOrgIdList = IfmSettleCenterHelper.getAuthorizedRegisteredSettleCenterIds((Long)RequestContext.get().getCurrUserId(), (String)TmcAppEnum.IFM.getValue(), (String)"ifm_inerestcalculationrpt", (String)"47150e89000000ac");
        QFilter finOrgIdFilter = new QFilter("id", "in", (Object)finOrgIdList);
        showPara.getListFilterParameter().setFilter(finOrgIdFilter);
    }

    private void setIntObjectF7Filter(BeforeF7SelectEvent evt) {
        DynamicObjectCollection companyCol;
        DynamicObjectCollection currencyCol;
        QFilter filter = null;
        DynamicObject settleCenter = (DynamicObject)this.getModel().getValue("filter_settlecenter");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleCenter)) {
            filter = new QFilter("settlecenter", "=", settleCenter.getPkValue());
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencyCol = (DynamicObjectCollection)this.getModel().getValue("filter_currency")))) {
            QFilter currencyFilter = new QFilter("currency", "in", (Object)currencyCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).toArray());
            QFilter qFilter = filter = null == filter ? currencyFilter : filter.and(currencyFilter);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(companyCol = (DynamicObjectCollection)this.getModel().getValue("filter_company")))) {
            QFilter companyFilter = new QFilter("intobject.company", "in", (Object)companyCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).toArray());
            QFilter qFilter = filter = null == filter ? companyFilter : filter.and(companyFilter);
        }
        if (EmptyUtil.isNoEmpty((Object)filter)) {
            ListShowParameter showPara = (ListShowParameter)evt.getFormShowParameter();
            showPara.getListFilterParameter().setFilter(filter);
        }
    }

    private void initViewParam(DynamicObject rowData, FormShowParameter parameter) {
        IntBillDetailInfo firstIntDetail;
        Date endDate;
        Date startDate;
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingle((Object)rowData.getLong("bankacctid"), (String)"bd_accountbanks");
        DynamicObject intObject = TmcDataServiceHelper.loadSingle((Object)rowData.getLong("intobjectid"), (String)"ifm_intobject");
        DynamicObject currency = rowData.getDynamicObject("currency");
        IntBillInfo intBill = InterestCalcHelper.callInt((DynamicObject)bankAcct, (DynamicObject)currency, (Date)(startDate = rowData.getDate("interestdatestart")), (Date)DateUtils.getNextDay((Date)(endDate = rowData.getDate("interestdateend")), (int)1), (boolean)intObject.getBoolean("iscaloverint"));
        if (EmptyUtil.isNoEmpty((Object)intBill) && EmptyUtil.isNoEmpty((Object)intBill.getDetails()) && DateUtils.getDiffDays((Date)startDate, (Date)(firstIntDetail = (IntBillDetailInfo)intBill.getDetails().get(0)).getBeginDate()) != 0) {
            firstIntDetail.setBeginDate(startDate);
            firstIntDetail.setDays(DateUtils.getDiffDays((Date)startDate, (Date)firstIntDetail.getEndDate()));
        }
        parameter.getCustomParams().put("intdetail", SerializationUtils.toJsonString((Object)intBill));
        parameter.getCustomParams().put("currency", currency.getPkValue());
        parameter.getCustomParams().put("currentinttype", "true");
    }

    private void setExRateTable(Long settleCenterId) {
        if (EmptyUtil.isEmpty((Long)settleCenterId)) {
            this.getModel().setValue("filter_exratetable", null);
            return;
        }
        DynamicObject finOrgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)settleCenterId, (String)"bd_finorginfo");
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)finOrgInfo.getLong("org.id"));
        if (EmptyUtil.isNoEmpty((Object)baseAccountingInfo)) {
            Long exRateTableId = (Long)baseAccountingInfo.get("exchangeRateTableID");
            this.getModel().setValue("filter_exratetable", (Object)exRateTableId);
        }
    }
}

