/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.report.print;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class StatementReportPrintPlugin
extends AbstractPrintServicePlugin {
    private static Log logger = LogFactory.getLog(StatementReportPrintPlugin.class);

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        String pageId = e.getPageId();
        List dynS = e.getDataEntities();
        String datasource = e.getDataSourceName();
        logger.info("\u5bf9\u8d26\u5355\u67e5\u8be2\u62a5\u8868\u6253\u5370\u6a21\u677f1");
        if ("ifm_statement_info".equals(datasource)) {
            DynamicObject selectedRowData = this.getSelectedRowData(pageId);
            if (Objects.nonNull(selectedRowData)) {
                this.initPrintStatementData(dynS, selectedRowData);
            }
            e.setDataEntities(dynS);
            logger.info("\u5bf9\u8d26\u5355\u67e5\u8be2\u62a5\u8868\u6253\u5370\u6a21\u677f2");
        } else if ("ifm_trans_info".equals(datasource)) {
            DynamicObject selectedRowData = this.getSelectedRowData(pageId);
            if (Objects.nonNull(selectedRowData)) {
                this.initPrintTransData(dynS, selectedRowData);
            }
            e.setDataEntities(dynS);
            logger.info("\u5bf9\u8d26\u5355\u67e5\u8be2\u62a5\u8868\u6253\u5370\u6a21\u677f3");
        }
    }

    private DynamicObject getSelectedRowData(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        String formId = view.getFormShowParameter().getFormId();
        ReportView views = (ReportView)SessionManager.getCurrent().getView(pageId);
        ReportList list = views.getReportList();
        int[] selectRows = list.getEntryState().getSelectedRows();
        DynamicObject result = null;
        if ("ifm_statementrpt".equals(formId)) {
            ReportListModel reportModel = (ReportListModel)list.getReportModel();
            DynamicObjectCollection ds = reportModel.getRowData(selectRows[0] - 1, 1);
            result = (DynamicObject)ds.get(0);
        }
        return result;
    }

    private void initPrintStatementData(List<DynamicObject> dynS, DynamicObject selectedObj) {
        DynamicObjectType dsDataType = new DynamicObjectType();
        dsDataType.registerProperty("title", String.class, (Object)"", false);
        dsDataType.registerProperty("account", String.class, (Object)"", false);
        dsDataType.registerProperty("currency", String.class, (Object)"", false);
        dsDataType.registerProperty("datestart", String.class, null, false);
        dsDataType.registerProperty("dateend", String.class, null, false);
        dsDataType.registerProperty("amountstart", BigDecimal.class, null, false);
        dsDataType.registerProperty("amountend", BigDecimal.class, null, false);
        dsDataType.registerProperty("debitamountsum", BigDecimal.class, null, false);
        dsDataType.registerProperty("creditamountsum", BigDecimal.class, null, false);
        Date dateStart = selectedObj.getDate("datestart");
        Date dateEnd = selectedObj.getDate("dateend");
        if (Objects.isNull(dateStart)) {
            DynamicObject dbObj = TmcDataServiceHelper.loadSingle((Object)selectedObj.get("inneraccount.id"), (String)"am_accountbank");
            dateStart = dbObj.getDate("opendate");
        }
        if (Objects.isNull(dateEnd)) {
            dateEnd = new Date();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateStartStr = formatter.format(dateStart);
        String dateEndStr = formatter.format(dateEnd);
        DynamicObject newDynamicRow = new DynamicObject(dsDataType);
        newDynamicRow.set("title", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u8d26\u5355", (String)"StatementReportPrintPlugin_0", (String)"tmc-ifm-report", (Object[])new Object[0]), selectedObj.getString("inneraccount.bank.name")));
        newDynamicRow.set("account", (Object)selectedObj.getString("inneraccount.number"));
        newDynamicRow.set("currency", (Object)selectedObj.getString("currency.name"));
        newDynamicRow.set("datestart", (Object)dateStartStr);
        newDynamicRow.set("dateend", (Object)dateEndStr);
        newDynamicRow.set("amountstart", (Object)selectedObj.getBigDecimal("amountstart").setScale(2, RoundingMode.HALF_UP));
        newDynamicRow.set("amountend", (Object)selectedObj.getBigDecimal("amountend").setScale(2, RoundingMode.HALF_UP));
        newDynamicRow.set("debitamountsum", (Object)selectedObj.getBigDecimal("currpay").setScale(2, RoundingMode.HALF_UP));
        newDynamicRow.set("creditamountsum", (Object)selectedObj.getBigDecimal("currincome").setScale(2, RoundingMode.HALF_UP));
        dynS.add(newDynamicRow);
    }

    private void initPrintTransData(List<DynamicObject> dynS, DynamicObject selectedObj) {
        DynamicObjectType dsDataType = new DynamicObjectType();
        dsDataType.registerProperty("bizdate", String.class, null, false);
        dsDataType.registerProperty("description", String.class, (Object)"", false);
        dsDataType.registerProperty("transdetailno", String.class, (Object)"", false);
        dsDataType.registerProperty("amountstart", BigDecimal.class, null, false);
        dsDataType.registerProperty("amountend", BigDecimal.class, null, false);
        dsDataType.registerProperty("currincome", BigDecimal.class, null, false);
        dsDataType.registerProperty("currpay", BigDecimal.class, null, false);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter accountFilter = new QFilter("accountbank", "=", selectedObj.get("inneraccount.id"));
        QFilter currencyFilter = new QFilter("currency", "=", selectedObj.get("currency.id"));
        qFilterList.add(accountFilter);
        qFilterList.add(currencyFilter);
        Date dateStart = selectedObj.getDate("datestart");
        Date datesEnd = selectedObj.getDate("dateend");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (!Objects.isNull(dateStart)) {
            qFilterList.add(new QFilter("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)dateStart, (boolean)Boolean.TRUE)));
        }
        if (!Objects.isNull(datesEnd)) {
            qFilterList.add(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)datesEnd, (boolean)Boolean.FALSE)));
        }
        String selectField = "id,company.id,accountbank.id,accountbank.bankaccountnumber,currency.id,description,transbalance,creditamount,debitamount,bizdate,billno";
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)"ifm_transdetail", (String)selectField, (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"bizdate asc, biztime asc");
        BigDecimal amountstart = selectedObj.getBigDecimal("amountstart").setScale(2, RoundingMode.HALF_UP);
        for (DynamicObject dynamicObject : dataList) {
            DynamicObject newDynamicRow = new DynamicObject(dsDataType);
            BigDecimal debitAmount = dynamicObject.getBigDecimal("debitamount");
            BigDecimal creditAmount = dynamicObject.getBigDecimal("creditamount");
            BigDecimal transBalance = amountstart.add(creditAmount).subtract(debitAmount);
            newDynamicRow.set("bizdate", (Object)formatter.format(dynamicObject.get("bizdate")));
            newDynamicRow.set("description", dynamicObject.get("description"));
            newDynamicRow.set("transdetailno", dynamicObject.get("billno"));
            newDynamicRow.set("amountstart", (Object)amountstart.setScale(2, RoundingMode.HALF_UP));
            newDynamicRow.set("amountend", (Object)transBalance.setScale(2, RoundingMode.HALF_UP));
            newDynamicRow.set("currincome", (Object)debitAmount.setScale(2, RoundingMode.HALF_UP));
            newDynamicRow.set("currpay", (Object)creditAmount.setScale(2, RoundingMode.HALF_UP));
            dynS.add(newDynamicRow);
            amountstart = transBalance;
        }
    }
}

