/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.ifm.opplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.AcctClassifyEnum;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.opplugin.sysimport.AbstractTmcBatchImportPlugin;
import kd.tmc.ifm.enums.BizStatusEnum;
import kd.tmc.ifm.enums.DeductionTypeEnum;

public class DeductionBatchImportOp
extends AbstractTmcBatchImportPlugin {
    private static final Log logger = LogFactory.getLog(DeductionBatchImportOp.class);

    protected void beforeImportOp(Map<String, Object> rowdata, Map<String, Object> option) {
        logger.info("\u7ed3\u7b97\u4e2d\u5fc3\u6263\u6b3e\u5bfc\u5165data:" + ((JSONObject)rowdata).toJSONString());
        this.checkImportType(rowdata);
        this.verifyData(rowdata);
        this.setData(rowdata);
    }

    private void checkImportType(Map<String, Object> data) {
        String importType = this.getCurrentImportType();
        List selectKeyFields = this.getSelectKeyFields();
        if ("override".equals(String.valueOf(importType)) || "overridenew".equals(String.valueOf(importType))) {
            for (String selectKeyField : selectKeyFields) {
                if ("billno".equals(selectKeyField)) {
                    String billno = (String)data.get("billno");
                    QFilter filter = new QFilter("billno", "=", (Object)billno).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())).and(new QFilter("bizstatus", "=", (Object)BizStatusEnum.NORMAL.getValue()));
                    boolean exists = QueryServiceHelper.exists((String)"ifm_deduction", (QFilter[])new QFilter[]{filter});
                    if (exists) continue;
                    this.throwException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6682\u5b58\u5e76\u4e14\u4e1a\u52a1\u72b6\u6001\u4e3a\u6b63\u5e38\u7684\u6570\u636e\u7684\u8fdb\u884c\u4fee\u6539\u3002", (String)"DeductionBatchImportOp_1", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
                    continue;
                }
                this.throwException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5355\u636e\u7f16\u53f7\u8fdb\u884c\u4fee\u6539\u3002", (String)"DeductionBatchImportOp_3", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
            }
        }
    }

    private void verifyData(Map<String, Object> rowdata) {
        this.verufyMustInput(rowdata);
        this.verifyCenter(rowdata);
        this.verifyReceiveAccount(rowdata);
        this.verifyPayAccount(rowdata);
        this.verifyCurrency(rowdata);
    }

    private void verifyCurrency(Map<String, Object> rowdata) {
        JSONObject receiveCurrency = (JSONObject)rowdata.get("receivecurrency");
        String receiveCurrencyNumber = (String)receiveCurrency.get((Object)"number");
        JSONArray entries = (JSONArray)rowdata.get("entryentity");
        for (Object entry : entries) {
            String number;
            JSONObject emtryJson = (JSONObject)entry;
            JSONObject paycurrency = (JSONObject)emtryJson.get((Object)"paycurrency");
            if (paycurrency == null) {
                this.throwException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6263\u6b3e\u660e\u7ec6(\u652f\u51fa\u65b9)\u5206\u5f55\u7684\u5e01\u79cd\u201c\u3002", (String)"DeductionBatchImportOp_4", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
            }
            if (Objects.equals(number = (String)paycurrency.get((Object)"number"), receiveCurrencyNumber)) continue;
            this.throwException(ResManager.loadKDString((String)"\u5e01\u79cd\u548c\u6263\u6b3e\u660e\u7ec6(\u652f\u51fa\u65b9)\u5206\u5f55\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4,\u8bf7\u4fee\u6539\u201c\u3002", (String)"DeductionBatchImportOp_6", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    private void verufyMustInput(Map<String, Object> rowdata) {
        JSONObject settleType;
        String type = (String)rowdata.get("deductiontype");
        String payeeType = (String)rowdata.get("payeetype");
        JSONObject receiveCurrency = (JSONObject)rowdata.get("receivecurrency");
        if (Objects.equals(DeductionTypeEnum.CENTER_AGENT.getValue(), type) && EmptyUtil.isEmpty((String)payeeType)) {
            this.throwException(ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8\uff0c\u8bf7\u586b\u5199\u201c\u6536\u6b3e\u4eba\u7c7b\u578b\u201c\u3002", (String)"DeductionBatchImportOp_8", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
        } else if (Objects.equals(DeductionTypeEnum.AGENT_DEDUCTION.getValue(), type)) {
            JSONObject receiveCompany = (JSONObject)rowdata.get("receivecompany");
            JSONObject receiveAccount = (JSONObject)rowdata.get("receiveaccount");
            if (EmptyUtil.isEmpty((Object)receiveCompany)) {
                this.throwException(ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u6263,\u8bf7\u586b\u5199\u201c\u6536\u6b3e\u65b9\u201c\u3002", (String)"DeductionBatchImportOp_9", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
            }
            if (EmptyUtil.isEmpty((Object)receiveAccount)) {
                this.throwException(ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u6263,\u8bf7\u586b\u5199\u201c\u6536\u6b3e\u8d26\u53f7\u201c\u3002", (String)"DeductionBatchImportOp_10", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
            }
        } else if (Objects.equals(DeductionTypeEnum.CENTER_AGENT.getValue(), type) && EmptyUtil.isEmpty((Object)(settleType = (JSONObject)rowdata.get("settletype")))) {
            this.throwException(ResManager.loadKDString((String)"\u6263\u6b3e\u7c7b\u578b\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u4ee3\u4ed8,\u8bf7\u586b\u5199\u201c\u7ed3\u7b97\u65b9\u5f0f\u201c\u3002", (String)"DeductionBatchImportOp_12", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        if (receiveCurrency == null) {
            this.throwException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6536\u6b3e\u5e01\u79cd\u201c\u3002", (String)"DeductionBatchImportOp_11", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    private void setData(Map<String, Object> rowdata) {
        QFilter companyFilter;
        DynamicObject org;
        JSONObject receiveCompany = (JSONObject)rowdata.get("receivecompany");
        if (receiveCompany != null && (org = TmcDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{companyFilter = new QFilter("number", "=", receiveCompany.get((Object)"number"))})) != null) {
            rowdata.put("payee", org.getPkValue());
            rowdata.put("payeename", org.getString("name"));
        }
        JSONArray entries = (JSONArray)rowdata.get("entryentity");
        BigDecimal totalPayAmount = entries.stream().map(d -> ((JSONObject)d).getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        rowdata.put("receiveamount", totalPayAmount);
        String type = (String)rowdata.get("deductiontype");
        if (Objects.equals(DeductionTypeEnum.DEDUCTION.getValue(), type) && !EmptyUtil.isEmpty((Collection)entries)) {
            JSONObject jsonObject = (JSONObject)entries.get(0);
            rowdata.put("receivecurrency", jsonObject.get((Object)"paycurrency"));
        }
        Object comment = rowdata.get("comment");
        boolean isBackFill = (Boolean)rowdata.get("isbackfill");
        if (isBackFill) {
            for (Object entry : entries) {
                JSONObject entryJson = (JSONObject)entry;
                if (!EmptyUtil.isEmpty((Object)entryJson.get((Object)"transfercomment"))) continue;
                entryJson.put("transfercomment", comment);
            }
        }
    }

    private void verifyPayAccount(Map<String, Object> rowdata) {
        JSONArray entries = (JSONArray)rowdata.get("entryentity");
        for (Object entry : entries) {
            JSONObject entryJson = (JSONObject)entry;
            JSONObject payaccount = (JSONObject)entryJson.get((Object)"payaccount");
            if (payaccount == null) continue;
            JSONObject payCompany = (JSONObject)entryJson.get((Object)"paycompany");
            String bankAccountNumber = (String)payaccount.get((Object)"bankaccountnumber");
            QFilter acctTypeFilter = new QFilter("accttype", "!=", (Object)AcctTypeEnum.IN.getValue());
            QFilter companyFilter = new QFilter("company.number", "=", payCompany.get((Object)"number"));
            companyFilter.and("bankaccountnumber", "=", (Object)bankAccountNumber);
            boolean exists = TmcDataServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{this.getFilterChina(rowdata), acctTypeFilter, companyFilter});
            if (exists) continue;
            this.throwException(ResManager.loadKDString((String)"\u6263\u6b3e\u660e\u7ec6\u7684\u8d26\u53f7\u3010%s\u3011\uff0c\u4e0d\u6ee1\u8db3\u67e5\u8be2\u6761\u4ef6\uff0c\u4e0d\u80fd\u5bfc\u5165\uff01", (String)"DeductionBatchImportOp_5", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), bankAccountNumber);
        }
    }

    private QFilter getFilterChina(Map<String, Object> rowdata) {
        JSONObject center = (JSONObject)rowdata.get("center");
        QFilter acctStatusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        QFilter acctClassifyFilter = new QFilter("acctclassify", "=", (Object)AcctClassifyEnum.INNER_ACCOUNT.getValue());
        QFilter openBankFilter = new QFilter("bank.number", "=", center.get((Object)"number"));
        return acctStatusFilter.and(acctClassifyFilter).and(openBankFilter);
    }

    private void verifyReceiveAccount(Map<String, Object> rowdata) {
        String type = (String)rowdata.get("deductiontype");
        JSONObject receiveAccount = (JSONObject)rowdata.get("receiveaccount");
        JSONObject receiveCompany = (JSONObject)rowdata.get("receivecompany");
        if (!EmptyUtil.isEmpty((Object)receiveAccount)) {
            String bankAccountNumber = (String)receiveAccount.get((Object)"bankaccountnumber");
            QFilter acctTypeFilter = new QFilter("accttype", "!=", (Object)AcctTypeEnum.OUT.getValue());
            QFilter companyFilter = new QFilter("company.number", "=", receiveCompany.get((Object)"number"));
            companyFilter.and("bankaccountnumber", "=", (Object)bankAccountNumber);
            DynamicObject acoountBank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{this.getFilterChina(rowdata), acctTypeFilter, companyFilter});
            if (acoountBank == null) {
                this.throwException(ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u3010%s\u3011\uff0c\u4e0d\u6ee1\u8db3\u67e5\u8be2\u6761\u4ef6\uff0c\u4e0d\u80fd\u5bfc\u5165\uff01", (String)"DeductionBatchImportOp_2", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), bankAccountNumber);
            }
        }
    }

    private void verifyCenter(Map<String, Object> rowdata) {
        JSONObject center = (JSONObject)rowdata.get("center");
        if (center != null) {
            Map companyByOrg;
            QFilter finOrgTypeFilter = new QFilter("finorgtype.type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"ifm", (String)"ifm_deduction", (String)"47150e89000000ac");
            finOrgTypeFilter.and("org", "in", (Object)orgIdList);
            finOrgTypeFilter.and("number", "in", center.get((Object)"number"));
            DynamicObject centerDo = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (String)"id,org", (QFilter[])new QFilter[]{finOrgTypeFilter});
            if (centerDo == null) {
                this.throwException(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u3010%s\u3011\uff0c\u4e0d\u6ee1\u8db3\u7ed3\u7b97\u4e2d\u5fc3\u67e5\u8be2\u6761\u4ef6\uff0c\u4e0d\u80fd\u5bfc\u5165\uff01", (String)"DeductionBatchImportOp_0", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), center.get((Object)"number"));
            }
            DynamicObject org = centerDo.getDynamicObject("org");
            JSONObject scorg = (JSONObject)rowdata.get("scorg");
            if (!Objects.equals(org.get("number"), scorg.get((Object)"number"))) {
                this.throwException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u5fc5\u987b\u8981\u7b49\u4e8e\u7ed3\u7b97\u4e2d\u5fc3\u7684\u7ec4\u7ec7\u3002", (String)"DeductionBatchImportOp_7", (String)"tmc-ifm-opplugin", (Object[])new Object[0]), center.get((Object)"number"));
            }
            if (null != (companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()))) && companyByOrg.size() > 0) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", companyByOrg.get("id"));
                jsonObject.put("importprop", (Object)"id");
                rowdata.put("openorg", jsonObject);
            }
        }
    }

    private void throwException(String format, Object ... args) {
        String exMsg = String.format(format, args);
        throw new KDBizException(exMsg);
    }

    protected void afterImportOp(List<Map<String, Object>> datas) {
    }
}

